/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.update;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.unparse.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12 $
 */
public class LogicFsaTranslator
    implements Translator
{
   /**
    * Constructor for class LogicFsaTranslator
    *
    * @param fsaObject  No description provided
    * @param ancestor   No description provided
    */
   public LogicFsaTranslator (FSAObject fsaObject, int ancestor)
   {
      setAncestor (ancestor);
      setFsaObject (fsaObject);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int ancestor;


   /**
    * Sets the ancestor attribute of the LogicFsaTranslator object
    *
    * @param value  The new ancestor value
    * @return       No description provided
    */
   public boolean setAncestor (int value)
   {
      if (this.ancestor != value)
      {
         this.ancestor = value;
         return true;
      }

      return false;
   }


   /**
    * Get the ancestor attribute of the LogicFsaTranslator object
    *
    * @return   The ancestor value
    */
   public int getAncestor()
   {
      return this.ancestor;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FSAObject fsaObject;


   /**
    * Sets the fsaObject attribute of the LogicFsaTranslator object
    *
    * @param value  The new fsaObject value
    * @return       No description provided
    */
   public boolean setFsaObject (FSAObject value)
   {
      if (this.fsaObject != value)
      {
         this.fsaObject = value;
         return true;
      }

      return false;
   }


   /**
    * Get the fsaObject attribute of the LogicFsaTranslator object
    *
    * @return   The fsaObject value
    */
   public FSAObject getFsaObject()
   {
      return this.fsaObject;
   }


   /**
    * translate new target (LogicUnparseInterface) to an according FSAObject for the diagram.
    * If none exists, unparse target and return the result
    *
    * @param data  No description provided
    * @return      No description provided
    */
   public Object translateLogicToFsa (Object data)
   {
      FSAObject result = null;
      if (data != null &&  (data instanceof LogicUnparseInterface))
      {
         LogicUnparseInterface targetIncr = (LogicUnparseInterface) data;
         FSAInterface iface = targetIncr.getFSAInterface();
         if (iface != null)
         {
            UnparseInterface unparser = UnparseManager.get().getUnparseModule (targetIncr);
            if (unparser != null)
            {
               FSAObject parent = retrieveAncestor();
               result = iface.getFromFsaObjects (FSAObject.getID (parent) + "." + unparser.getMainFsaName());

               if (result == null && iface.isUnparse())
               {
                  result = UnparseManager.get().unparse (targetIncr, parent);
               }
            }
         }
      }

      return result;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private FSAObject retrieveAncestor()
   {
      FSAObject result = fsaObject;
      for (int i = 0; i < this.ancestor && result != null; i++)
      {
         result = result.getParent();
      } // for
      return result;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param data  No description provided
    * @return      No description provided
    */
   public Object translateFsaToLogic (Object data)
   {
      LogicUnparseInterface result = null;

      if (data != null)
      {
         FSAObject fsa = null;
         if (data instanceof FSAObject)
         {
            fsa = (FSAObject) data;
         }
         else if (data instanceof JComponent)
         {
            fsa = FSAObject.getFSAObjectFromJComponent ((JComponent) data);
         }
         if (fsa != null)
         {
            result = fsa.getLogic();
         }
      }
      return result;
   }
}

/*
 * $Log: LogicFsaTranslator.java,v $
 * Revision 1.12  2004/11/03 10:18:02  lowende
 * Javadoc warnings removed.
 *
 */
