/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.update;

import java.beans.PropertyChangeListener;
import java.util.EventListener;


/**
 * add and handle listener between fsa and logic
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.11 $
 */
public class LogicAndFsaUpdater
    extends LogicToFsaUpdater
{
   /**
    * Default Constructor
    */
   public LogicAndFsaUpdater()
   {
      super();
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "LogicAndFsaUpdater";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private EventListener fsaListener = null;


   /**
    * Sets the fsaListener attribute of the LogicAndFsaUpdater object
    *
    * @param listener  The new fsaListener value
    * @return          No description provided
    */
   boolean setFsaListener (EventListener listener)
   {
      if (listener != fsaListener)
      {
         boolean active = isListenerActive();

         if (active)
         {
            removeListener();
         }
         this.fsaListener = listener;
         if (active)
         {
            addListener();
         }
         return true;
      }
      return false;
   }


   /**
    * Get the fsaListener attribute of the LogicAndFsaUpdater object
    *
    * @return   The fsaListener value
    */
   public EventListener getFsaListener()
   {
      return fsaListener;
   }


   /**
    * Access method for an one to n association.
    */
   protected void addListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null))
      {
         super.addListener();

         if (getFsaListener() == null)
         {
            setFsaListener (new FsaToLogicUpdatePCL (this, getLogicAttrName(),
               getLogicObject()));
         }
         getFsaObject().addPropertyChangeListener (getFsaAttrName(), (PropertyChangeListener) getFsaListener());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void removeListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null))
      {
         super.removeListener();

         if (getFsaListener() != null)
         {
            getFsaObject().removePropertyChangeListener (getFsaAttrName(), (PropertyChangeListener) getFsaListener());
         }
      }
   }
}

/*
 * $Log: LogicAndFsaUpdater.java,v $
 * Revision 1.11  2004/10/20 17:49:51  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
