/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.update;

import java.beans.PropertyChangeListener;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.unparse.*;
import de.uni_paderborn.fujaba.metamodel.FElement;


/**
 * handle changes to target of UMLRole by setting target of associated grab accordingly
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.15 $
 */
public class GrabTargetUpdater
    extends LogicToFsaUpdater
{
   /**
    * Default Constructor
    */
   public GrabTargetUpdater()
   {
      super();
      super.setFsaAttrName ("target");
   }


   /**
    * Constructor for class GrabTargetUpdater
    *
    * @param incr  No description provided
    * @param attr  No description provided
    */
   public GrabTargetUpdater (FElement incr, String attr)
   {
      this();
      setLogicObject (incr);
      setLogicAttrName (attr);
   }


   /**
    * Sets the logicObject attribute of the GrabTargetUpdater object
    *
    * @param object  The new logicObject value
    * @return        No description provided
    */
   public boolean setLogicObject (Object object)
   {
      if (object == null || object instanceof LogicUnparseInterface)
      {
         return super.setLogicObject (object);
      }
      throw new IllegalArgumentException ("Object must be of type LogicUnparseInterface");
   }


   /**
    * Sets the fsaAttrName attribute of the GrabTargetUpdater object
    *
    * @param name  The new fsaAttrName value
    * @return      No description provided
    */
   public boolean setFsaAttrName (String name)
   {
      if ("target".equals (name))
      {
         return false;
      }

      throw new UnsupportedOperationException ("Cannot change GrabTargetUpdater.fsaAttrName from \"target\"");
   }


   /**
    * translate new target (UMLIncrement) to an according FSAObject for the diagram. If none
    * exists, unparse target and return the result
    *
    * @param data  No description provided
    * @return      No description provided
    */
   public Object translateLogicToFsa (Object data)
   {
      if (data == null || ! (data instanceof LogicUnparseInterface))
      {
         return null;
      }

      LogicUnparseInterface targetIncr = (LogicUnparseInterface) data;
      FSAInterface fsaInterface = targetIncr.getFSAInterface();
      FSAObject target = fsaInterface.getFromFsaObjects (getFsaObject().getParentID() + fsaInterface.getMainFsaName());

      if (target == null)
      {
         FSAObject parent = getFsaObject().getParent();
         LogicUnparseInterface logic = parent.getLogic();
         if ( (logic instanceof ASGDiagram) &&  (targetIncr instanceof ASGElement))
         {
            if (! ((FElement) targetIncr).hasInDiagrams ((ASGDiagram) logic))
            {
               return null;
            }
         }
         target = UnparseManager.get().unparse (targetIncr, getFsaObject().getParent());
      }

      return target;
   }


   /**
    * Access method for an one to n association.
    */
   protected void addListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() == null)
         {
            setLogicListener (new LogicToFsaUpdatePCL (this, getFsaAttrName(),
               getFsaObject()));
         }
          ((LogicUnparseInterface) getLogicObject()).getPropertyChangeSupport().
            addPropertyChangeListener (getLogicAttrName(), (PropertyChangeListener) getLogicListener());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void removeListener()
   {
      if (! (getLogicObject() == null || getLogicAttrName() == null ||
         getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() != null)
         {
             ((LogicUnparseInterface) getLogicObject()).getPropertyChangeSupport().
               removePropertyChangeListener (getLogicAttrName(), (PropertyChangeListener) getLogicListener());
         }
      }
   }
}

/*
 * $Log: GrabTargetUpdater.java,v $
 * Revision 1.15  2004/11/03 10:18:02  lowende
 * Javadoc warnings removed.
 *
 */
