/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.update;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.fsa.FSADerivePropertyMethodsCache;


/**
 * set logicObject.attrName if FSAObject has changed
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.13.2.1 $
 */
public class FsaToLogicUpdatePCL
    implements PropertyChangeListener
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (FsaToLogicUpdatePCL.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private AbstractUpdater updater;


   /**
    * Get the value of updater.
    *
    * @return   Value of updater.
    */
   public AbstractUpdater getUpdater()
   {
      return this.updater;
   }


   /**
    * Set the value of updater.
    *
    * @param updater  Value to assign to updater.
    */
   public synchronized void setUpdater (AbstractUpdater updater)
   {
      if (this.updater != updater)
      {
         this.updater = updater;
      }
   }


   /**
    * UMLAttribute : 'logicObject : UMLUnparseInterface '
    */
   private Object logicObject;


   /**
    * Get the value of logicObject.
    *
    * @return   Value of logicObject.
    */
   public Object getLogicObject()
   {
      return this.logicObject;
   }


   /**
    * Set the value of logicObject.
    *
    * @param logicObject  Value to assign to logicObject.
    */
   public synchronized void setLogicObject (Object logicObject)
   {
      if (this.logicObject != logicObject)
      {
         this.logicObject = logicObject;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Class logicObjectClass = null;


   /**
    * Get the logicObjectClass attribute of the FsaToLogicUpdatePCL object
    *
    * @return   The logicObjectClass value
    */
   private Class getLogicObjectClass()
   {
      if (logicObjectClass == null)
      {
         logicObjectClass = getLogicObject().getClass();
      }

      return logicObjectClass;
   }


   /**
    * UMLAttribute : 'attrName : String '
    */
   private String attrName;


   /**
    * Get the value of attrName.
    *
    * @return   Value of attrName.
    */
   public String getAttrName()
   {
      return this.attrName;
   }


   /**
    * Set the value of attrName.
    *
    * @param attrName  Value to assign to attrName.
    */
   public synchronized void setAttrName (String attrName)
   {
      if ( (this.attrName == null && attrName != null) ||
          (this.attrName != null && !this.attrName.equals (attrName)))
      {
         this.attrName = attrName;
      }
   }


   /**
    * Default Constructor
    *
    * @param updater      No description provided
    * @param attrName     No description provided
    * @param logicObject  No description provided
    */
   public FsaToLogicUpdatePCL (AbstractUpdater updater, String attrName,
                               Object logicObject)
   {
      setUpdater (updater);
      setLogicObject (logicObject);
      setAttrName (attrName);
   }


   /**
    * Constructor for class FsaToLogicUpdatePCL
    *
    * @param attrName     No description provided
    * @param logicObject  No description provided
    */
   public FsaToLogicUpdatePCL (String attrName,
                               Object logicObject)
   {
      this (null, attrName, logicObject);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void propertyChange (PropertyChangeEvent event)
   {
      Object incr;
      Class clazz;
      String attrName;
      Object[] args;
      synchronized (this)
      {
         args = new Object[]
            {
             (updater != null ?
            updater.getTranslator().translateFsaToLogic (event.getNewValue()) :
            event.getNewValue())
            };

         incr = getLogicObject();
         clazz = getLogicObjectClass();
         attrName = getAttrName();
      }

      Method[] methods = FSADerivePropertyMethodsCache.get().getPropertyMethods (attrName,
         clazz);
      Method setMethod = methods[1];

      try
      {
         if (setMethod != null)
         {
            setMethod.invoke (incr, args);
         }
         else
         {
            //FIX ME: maybe we should complain then
         }
      }
      catch (Exception exception)
      {
         if (log.isInfoEnabled())
         {
            log.info ("Exception in FsaToLogic");
         }
         if (exception instanceof InvocationTargetException)
         {
            InvocationTargetException ite = (InvocationTargetException) exception;
            log.error (ite.getTargetException().getMessage());
            ite.getTargetException().printStackTrace();
         }
         else if (exception instanceof RuntimeException)
         {
            throw (RuntimeException) exception;
         }
         else
         {
            throw new RuntimeException (this + ".propertyChange : " + exception);
         }
      }
   }
}

/*
 * $Log: FsaToLogicUpdatePCL.java,v $
 * Revision 1.13.2.1  2005/09/30 18:57:00  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
