/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.update;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.uni_paderborn.fujaba.uml.UMLLink;


/**
 * Translate int to String and back
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public class ColorToModifierTranslator implements Translator
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static ColorToModifierTranslator singleton = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static ColorToModifierTranslator get()
   {
      if (singleton == null)
      {
         singleton = new ColorToModifierTranslator();
      }

      return singleton;
   }


   /**
    * Constructor for class StringToModifierTranslator
    */
   private ColorToModifierTranslator() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public Object translateFsaToLogic (Object value)
   {
      if (value != null)
      {
         if (value.equals (ColorsPreferences.get().CREATION))
         {
            return new Integer (UMLLink.CREATE);
         }
         else if (value.equals (ColorsPreferences.get().DELETION))
         {
            return new Integer (UMLLink.DELETE);
         }
         else
         {
            return new Integer (UMLLink.NONE);
         }
      }
      else
      {
         return null;
      }

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public Object translateLogicToFsa (Object value)
   {
      if (value != null)
      {
         int modifier =  ((Integer) value).intValue();
         switch (modifier)
         {
            case UMLLink.NONE:
            {
               return FSAObject.COLOR_FOREGROUND;
            }

            case UMLLink.CREATE:
            {
               return ColorsPreferences.get().CREATION;
            }

            case UMLLink.DELETE:
            {
               return ColorsPreferences.get().DELETION;
            }

            default:
            {
               return FSAObject.COLOR_FOREGROUND;
            }
         }
      }
      return value;
   }

}

/*
 * $Log: ColorToModifierTranslator.java,v $
 * Revision 1.11  2004/11/03 10:18:02  lowende
 * Javadoc warnings removed.
 *
 */
