/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.update;

import java.awt.*;

import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;

import de.uni_paderborn.fujaba.fsa.FSABorderFactory;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.swing.border.LineBorder;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.uni_paderborn.fujaba.uml.UMLObject;


/**
 * Translate int to Border
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 */
public class BorderToModifierTranslator implements Translator
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static BorderToModifierTranslator singleton = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static BorderToModifierTranslator get()
   {
      if (singleton == null)
      {
         singleton = new BorderToModifierTranslator();
      }

      return singleton;
   }


   /**
    * Constructor for class StringToModifierTranslator
    */
   private BorderToModifierTranslator() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public Object translateFsaToLogic (Object value)
   {
      return null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public Object translateLogicToFsa (Object value)
   {
      if (value != null)
      {
         Color borderColor = FSAObject.COLOR_FOREGROUND;
         AbstractBorder innerBorder = null;
         AbstractBorder outerBorder = null;

         int modifier =  ((Integer) value).intValue();
         switch (modifier)
         {
            case UMLObject.CREATE:
               borderColor = ColorsPreferences.get().CREATION;
               outerBorder = FSABorderFactory.get().getCreateBorder();
               break;
            case UMLObject.DELETE:
               borderColor = ColorsPreferences.get().DELETION;
               outerBorder = FSABorderFactory.get().getDeleteBorder();
               break;
            default:
               break;
         }
         innerBorder = new LineBorder (borderColor);
         return new CompoundBorder (outerBorder, innerBorder);
      }
      return value;
   }

}

/*
 * $Log: BorderToModifierTranslator.java,v $
 * Revision 1.10  2004/10/20 17:49:50  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
