/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.update;

import de.uni_paderborn.fujaba.fsa.FSAObject;


/**
 * base class for uml-fsa-update
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public abstract class AbstractUpdater implements Translator
{
   /**
    * Constructor for class AbstractUpdater
    */
   public AbstractUpdater()
   {
      setListenerActive (true);
   }


   /**
    * Get the translator attribute of the AbstractUpdater object
    *
    * @return   The translator value
    */
   public Translator getTranslator()
   {
      if (translator == null)
      {
         return this;
      }

      return translator;
   }


   /**
    * Sets the translator attribute of the AbstractUpdater object
    *
    * @param propValue  The new translator value
    */
   public void setTranslator (Translator propValue)
   {
      Translator oldTranslator = getTranslator();
      translator = propValue;
      if (oldTranslator != getTranslator())
      {
         boolean active = isListenerActive();
         setListenerActive (false);
         initialize();
         setListenerActive (active);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Translator translator = null;

   /**
    * UMLAttribute : 'logicObject : Object '
    */
   private Object logicObject;


   /**
    * Get the value of logicObject.
    *
    * @return   Value of logicObject.
    */
   public Object getLogicObject()
   {
      return this.logicObject;
   }


   /**
    * Set the value of logicObject.
    *
    * @param logicObject  Value to assign to logicObject.
    * @return             No description provided
    */
   public boolean setLogicObject (Object logicObject)
   {
      if (this.logicObject != logicObject)
      {
         boolean active = isListenerActive();
         setListenerActive (false);
         this.logicObject = logicObject;
         initialize();
         setListenerActive (active);
         return true;
      }
      return false;
   }


   /**
    * UMLAttribute : 'logicAttrName : String '
    */
   private String logicAttrName;


   /**
    * Get the value of logicAttrName.
    *
    * @return   Value of logicAttrName.
    */
   public String getLogicAttrName()
   {
      return this.logicAttrName;
   }


   /**
    * Set the value of logicAttrName.
    *
    * @param logicAttrName  Value to assign to logicAttrName.
    * @return               No description provided
    */
   public boolean setLogicAttrName (String logicAttrName)
   {
      if ( (this.logicAttrName == null && logicAttrName != null) ||
          (this.logicAttrName != null && !this.logicAttrName.equals (logicAttrName)))
      {
         boolean active = isListenerActive();
         setListenerActive (false);
         this.logicAttrName = logicAttrName;
         initialize();
         setListenerActive (active);
         return true;
      }
      return false;
   }


   /**
    * UMLAttribute : 'fsaAttrName : String '
    */
   private String fsaAttrName;


   /**
    * Get the value of fsaAttrName.
    *
    * @return   Value of fsaAttrName.
    */
   public String getFsaAttrName()
   {
      return this.fsaAttrName;
   }


   /**
    * Set the value of fsaAttrName.
    *
    * @param fsaAttrName  Value to assign to fsaAttrName.
    * @return             No description provided
    */
   public boolean setFsaAttrName (String fsaAttrName)
   {
      if ( (this.fsaAttrName == null && fsaAttrName != null) ||
          (this.fsaAttrName != null && !this.fsaAttrName.equals (fsaAttrName)))
      {
         boolean active = isListenerActive();
         setListenerActive (false);
         this.fsaAttrName = fsaAttrName;
         initialize();
         setListenerActive (active);
         return false;
      }
      return false;
   }


   /**
    * <pre>
    *                  N                0..1
    * AbstractUpdater ----------------------- FSAObject
    *                  updater     fsaObject
    * </pre>
    */
   private FSAObject fsaObject;


   /**
    * Sets the fsaObject attribute of the AbstractUpdater object
    *
    * @param value  The new fsaObject value
    * @return       No description provided
    */
   public boolean setFsaObject (FSAObject value)
   {
      if (this.fsaObject != value)
      {
         boolean active = isListenerActive();
         setListenerActive (false);
         if (this.fsaObject != null)
         {
            FSAObject oldValue = this.fsaObject;
            this.fsaObject = null;
            oldValue.removeFromUpdater (this);
         }
         this.fsaObject = value;
         if (value != null)
         {
            this.fsaObject.addToUpdater (this);
            initialize();
         }
         setListenerActive (active);

         return true;
      }

      return false;
   }


   /**
    * Get the fsaObject attribute of the AbstractUpdater object
    *
    * @return   The fsaObject value
    */
   public FSAObject getFsaObject()
   {
      return this.fsaObject;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return getClass() + " [getFsaObject=" + getFsaObject() + ",getFsaAttrName=" + getFsaAttrName() + ",getLogicObject=" + getLogicObject() + ",getLogicAttrName=" + getLogicAttrName() + "]";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param data  No description provided
    * @return      No description provided
    */
   public Object translateLogicToFsa (Object data)
   {
      return data;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param data  No description provided
    * @return      No description provided
    */
   public Object translateFsaToLogic (Object data)
   {
      return data;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean listenerActive = false;


   /**
    * Sets the listenerState attribute of the AbstractUpdater object
    *
    * @param state  The new listenerState value
    */
   void setListenerState (boolean state)
   {
      this.listenerActive = state;
   }


   /**
    * Sets the listenerActive attribute of the AbstractUpdater object
    *
    * @param active  The new listenerActive value
    * @return        No description provided
    */
   public boolean setListenerActive (boolean active)
   {
      if (listenerActive != active)
      {
         listenerActive = active;
         if (active)
         {
            addListener();
         }
         else
         {
            removeListener();
         }

         return true;
      }
      return false;
   }


   /**
    * Get the listenerActive attribute of the AbstractUpdater object
    *
    * @return   The listenerActive value
    */
   public boolean isListenerActive()
   {
      return listenerActive;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected abstract void initialize();


   /**
    * Access method for an one to n association.
    */
   protected abstract void addListener();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected abstract void removeListener();

}

/*
 * $Log: AbstractUpdater.java,v $
 * Revision 1.11  2004/11/03 10:18:01  lowende
 * Javadoc warnings removed.
 *
 */
