/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.unparse;

import java.lang.ref.*;
import java.util.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.8 $
 */
public class WeakKey extends WeakReference
{
   /**
    * Hashcode of key, stored here since the key may be tossed by the GC
    */
   private final int hash;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final Set set;


   /**
    * Constructor for class WeakKey
    *
    * @param k    No description provided
    * @param set  No description provided
    */
   private WeakKey (Object k, Set set)
   {
      super (k);
      hash = k.hashCode();
      this.set = set;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param k    No description provided
    * @param set  No description provided
    * @return     No description provided
    */
   public static WeakKey create (Object k, Set set)
   {
      if (k == null)
      {
         return null;
      }
      else
      {
         return new WeakKey (k, set);
      }
   }


   /**
    * Constructor for class WeakKey
    *
    * @param k    No description provided
    * @param set  No description provided
    * @param q    No description provided
    */
   private WeakKey (Object k, Set set, ReferenceQueue q)
   {
      super (k, q);
      hash = k.hashCode();
      this.set = set;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param k    No description provided
    * @param set  No description provided
    * @param q    No description provided
    * @return     No description provided
    */
   public static WeakKey create (Object k, Set set, ReferenceQueue q)
   {
      if (k == null)
      {
         return null;
      }
      else
      {
         return new WeakKey (k, set, q);
      }
   }


   /*
    *  A WeakKey is equal to another WeakKey iff they both refer to objects
    *  that are, in turn, equal according to their own equals methods
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param o  No description provided
    * @return   No description provided
    */
   public boolean equals (Object o)
   {
      boolean result = false;
      if (this == o)
      {
         result = true;
      }
      else if (o instanceof WeakKey)
      {
         Object t = this.get();
         Object u =  ((WeakKey) o).get();
         if ( (t == null) ||  (u == null))
         {
            result = false;
         }
         else if (t == u)
         {
            result = true;
         }
         else
         {
            result = t.equals (u);
         }
      }
      return result;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int hashCode()
   {
      return hash;
   }


   /**
    * Get the set attribute of the WeakKey object
    *
    * @return   The set value
    */
   public Set getSet()
   {
      return this.set;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.8 $
    */
   public static class ReferenceIterator implements Iterator
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private Iterator iterator;


      /**
       * Constructor for class ReferenceIterator
       *
       * @param iter  No description provided
       */
      public ReferenceIterator (Iterator iter)
      {
         this.iterator = iter;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @return   No description provided
       */
      public boolean hasNext()
      {
         return  (iterator != null && iterator.hasNext());
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @return   No description provided
       */
      public Object next()
      {
         if (iterator == null)
         {
            throw new NoSuchElementException();
         }
         Object value = iterator.next();
         if (value instanceof Reference)
         {
            value =  ((Reference) value).get();
         }
         else if (value instanceof Map.Entry)
         {
            Object mapKey =  ((Map.Entry) value).getKey();
            Object mapValue =  ((Map.Entry) value).getValue();
            boolean change = false;

            if (mapKey instanceof Reference)
            {
               change = true;
               mapKey =  ((Reference) mapKey).get();
            }
            if (mapValue instanceof Reference)
            {
               change = true;
               mapValue =  ((Reference) mapValue).get();
            }
            if (change)
            {
               value = new MapEntry (mapKey, mapValue);
            }
         } // else
         return value;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      public void remove()
      {
         if (iterator == null)
         {
            throw new UnsupportedOperationException();
         }
         iterator.remove();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.8 $
    */
   private final static class MapEntry implements Map.Entry
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private final Object key;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private Object value;


      /**
       * Constructor for class MapEntry
       *
       * @param key    No description provided
       * @param value  No description provided
       */
      public MapEntry (Object key, Object value)
      {
         this.key = key;
         this.value = value;
      }


      /**
       * Get the key attribute of the MapEntry object
       *
       * @return   The key value
       */
      public Object getKey()
      {
         return this.key;
      }


      /**
       * Get the value attribute of the MapEntry object
       *
       * @return   The value value
       */
      public Object getValue()
      {
         return this.value;
      }


      /**
       * Sets the value attribute of the MapEntry object
       *
       * @param value  The new value value
       * @return       No description provided
       */
      public Object setValue (Object value)
      {
         Object old = this.value;
         this.value = value;
         return old;
      }
   }
}

/*
 * $Log: WeakKey.java,v $
 * Revision 1.8  2004/11/03 10:18:01  lowende
 * Javadoc warnings removed.
 *
 */
