/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.unparse;

import de.upb.tools.pcs.PropertyChangeInterface;


/**
 * <h2>Associations</h2> <pre>
 *                        1     fsaInterface    0..1
 * LogicUnparseInterface ---------------------------- FSAInterface
 *                        logic         fsaInterface
 * </pre>
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12 $
 */
public interface LogicUnparseInterface extends PropertyChangeInterface
{
   /**
    * use code below for implementation<p>
    *
    * <code>
    * private FSAInterface fsaInterface = null;
    *
    * public synchronized FSAInterface getFSAInterface ()
    * {
    *    if (this.fsaInterface == null)
    *    {
    *       this.fsaInterface=new FSAInterface(this);
    *    }
    *    return this.fsaInterface;
    * }
    * </code> or let this method return null if you do not want any unparsing and fsa stuff.
    * <p>
    *
    * <strong>IMPORTANT:</strong> <em>This method should always return the same FSAInterface
    * for the whole lifetime of the LogicUnparseInterface!</em>
    *
    * @return   The fSAInterface value
    */
   public FSAInterface getFSAInterface();


   /*
    *  use code below for implementation
    *  {
    *  synchronized (this)
    *  {
    *  if (this.fsaInterface == null)
    *  {
    *  this.fsaInterface=new FSAInterface(this);
    *  }
    *  return this.fsaInterface;
    *  }
    *  }
    *  private FSAInterface fsaInterface = null;
    */
   /**
    * This Method should return the fully qualified Class name to the appropriate UnparseInterface
    * subclass that is to be used for unparsing. <p>
    *
    * If you do not need any special conversions use code below for implementation.<br>
    * That will return the qualified class name of this LogicUnparseInterface with "unparse"
    * appended to the package name and the class name prefixed with "UM".<br>
    * So <code>pack.age.name.ClassName</code> will become <code>pack.age.name.unparse.UMClassName</code>
    * . <p>
    *
    * This is the (expected) default location for the UnparseInterface <p>
    *
    * <code>
    * private String unparseModuleName = null;
    *
    * public String getUnparseModuleName ()
    * {
    *    if (this.unparseModuleName == null)
    *    {
    *       this.unparseModuleName=UnparseManager.get().getUnparseModuleName(this);
    *    }
    *    return this.unparseModuleName;
    * }
    * </code> or let this method return null if you do not want any unparsing and fsa stuff.
    * <p>
    *
    *
    *
    * @return   The unparseModuleName value
    */
   public String getUnparseModuleName();
   /*
    *  use code below for implementation
    *  {
    *  if (this.unparseModuleName == null)
    *  {
    *  this.unparseModuleName=UnparseManager.get().getUnparseModuleName(this);
    *  }
    *  return this.unparseModuleName;
    *  }
    *  private String unparseModuleName = null;
    */
}

/*
 * $Log: LogicUnparseInterface.java,v $
 * Revision 1.12  2004/11/03 10:18:01  lowende
 * Javadoc warnings removed.
 *
 */
