/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.unparse;

import java.util.Set;

import de.uni_paderborn.fujaba.fsa.FSAObject;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12 $
 */
public abstract class AbstractUnparseModule implements UnparseInterface
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String mainFsaName = null;


   /**
    * Constructor for class AbstractUnparseModule
    */
   public AbstractUnparseModule()
   {
      this ("entry");
   }


   /**
    * Constructor for class AbstractUnparseModule
    *
    * @param mainFsaName  No description provided
    */
   public AbstractUnparseModule (String mainFsaName)
   {
      this.mainFsaName = mainFsaName;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public abstract FSAObject create (FSAObject parent, LogicUnparseInterface incr);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param object  No description provided
    * @param incr    No description provided
    */
   public void remove (FSAObject object, LogicUnparseInterface incr)
   {
      object.setLogic (null);
      object.removeYou();
   }


   /**
    * basically this is the name of the main component for the Increment It is used to identify
    * where to unparse that increment to
    *
    * @return   The mainFsaName value
    */
   public String getMainFsaName()
   {
      return this.mainFsaName;
   }


   /**
    * Get the childProperties attribute of the AbstractUnparseModule object
    *
    * @param props  No description provided
    */
   public void getChildProperties (Set props) { }


   /**
    * Get the partnerProperties attribute of the AbstractUnparseModule object
    *
    * @param props  No description provided
    */
   public void getPartnerProperties (Set props) { }


   /**
    * maps propertyNames to the names of the components they should be unparsed to.
    *
    * @param property  No description provided
    * @return          The containerForProperty value
    */
   public String getContainerForProperty (String property)
   {
      return getMainFsaName();
   }
}

/*
 * $Log: AbstractUnparseModule.java,v $
 * Revision 1.12  2004/11/03 10:18:01  lowende
 * Javadoc warnings removed.
 *
 */
