/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import java.awt.*;

import de.uni_paderborn.fujaba.fsa.FSAObject;


/**
 * This border is used for SDL-Signals.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public class SignalBorder extends AbstractColorBorder
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int OUT = 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int IN = OUT + 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int SAVING = IN + 1;


   /**
    * Constructor for class SignalBorder
    *
    * @param shape  No description provided
    */
   public SignalBorder (int shape)
   {
      super();
      setSignalShape (shape);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int signalShape;


   /**
    * Get the signalShape attribute of the SignalBorder object
    *
    * @return   The signalShape value
    */
   public int getSignalShape()
   {
      return signalShape;
   }


   /**
    * Sets the signalShape attribute of the SignalBorder object
    *
    * @param shape  The new signalShape value
    */
   public void setSignalShape (int shape)
   {
      signalShape = shape;
   }


   /**
    * Get the borderInsets attribute of the SignalBorder object
    *
    * @param c  No description provided
    * @return   The borderInsets value
    */
   public Insets getBorderInsets (Component c)
   {
      if (getSignalShape() != SAVING)
      {
         return new Insets (2, 2, 2, 22);
      }
      else
      {
         return new Insets (2, 42, 2, 42);
      }

   }


   /**
    * Get the borderInsets attribute of the SignalBorder object
    *
    * @param c       No description provided
    * @param insets  No description provided
    * @return        The borderInsets value
    */
   public Insets getBorderInsets (Component c, Insets insets)
   {
      if (getSignalShape() != SAVING)
      {
         insets = new Insets (2, 2, 2, 22);
      }
      else
      {
         insets = new Insets (2, 42, 2, 42);
      }
      return insets;
   }


   /**
    * Get the borderOpaque attribute of the SignalBorder object
    *
    * @return   The borderOpaque value
    */
   public boolean isBorderOpaque()
   {
      return false;
   }


   /**
    * This method draws the Border for SDL-CreateProcess.
    *
    * @param c       No description provided
    * @param g       No description provided
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void paintBorder (Component c,
                            Graphics g,
                            int x,
                            int y,
                            int width,
                            int height)
   {
      Color oldColor = g.getColor();

      g.setColor (FSAObject.COLOR_FOREGROUND);

      // draw upper and lower line
      switch (getSignalShape())
      {
         case OUT:
            g.drawLine (x, y, x + width - 1 - 20, y);
            g.drawLine (x, y + height - 1, x + width - 1 - 20, y + height - 1);
         case IN:
            g.drawLine (x, y, x + width - 1, y);
            g.drawLine (x, y + height - 1, x + width - 1, y + height - 1);
         case SAVING:
            g.drawLine (x + 40, y, x + width - 1, y);
            g.drawLine (x, y + height - 1, x + width - 1 - 40, y + height - 1);
      }

      //draw left line
      if (getSignalShape() != SAVING)
      {
         g.drawLine (x, y, x, y + height - 1);
      }
      else
      {
         g.drawLine (x, y + height - 1, x + 40, y);
      }

      //draw the two right lines
      switch (getSignalShape())
      {
         case OUT:
            g.drawLine (x + width - 1 - 20, y, x + width - 1, y + height / 2);
            g.drawLine (x + width - 1, y + height / 2, x + width - 1 - 20, y + height - 1);
         case IN:
            g.drawLine (x + width - 1, y, x + width - 1 - 20, y + height / 2);
            g.drawLine (x + width - 1 - 20, y + height / 2, x + width - 1, y + height - 1);
         case SAVING:
            g.drawLine (x + width - 1, y, x + width - 1 - 40, y + height);
      }

      g.setColor (oldColor);
   }
}

/*
 * $Log: SignalBorder.java,v $
 * Revision 1.11  2004/11/03 10:18:00  lowende
 * Javadoc warnings removed.
 *
 */
