/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import java.awt.*;

import de.uni_paderborn.fujaba.fsa.FSAObject;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public class RhombBorder extends AbstractColorBorder
{
   /**
    * Constructor for class RhombBorder
    *
    * @param aColor  No description provided
    */
   public RhombBorder (Color aColor)
   {
      super();
      setBorderColor (aColor);
   }


   /**
    * Get the borderInsets attribute of the RhombBorder object
    *
    * @param c  No description provided
    * @return   The borderInsets value
    */
   public Insets getBorderInsets (Component c)
   {
      return new Insets (33, 33, 33, 33);
   }


   /**
    * Get the borderInsets attribute of the RhombBorder object
    *
    * @param c       No description provided
    * @param insets  No description provided
    * @return        The borderInsets value
    */
   public Insets getBorderInsets (Component c, Insets insets)
   {
      insets = getBorderInsets (c);
      return insets;
   }


   /**
    * Get the borderOpaque attribute of the RhombBorder object
    *
    * @return   The borderOpaque value
    */
   public boolean isBorderOpaque()
   {
      return true;
   }


   /**
    * This method draws the Border for Set objects.
    *
    * @param c       No description provided
    * @param g       No description provided
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void paintBorder (Component c,
                            Graphics g,
                            int x,
                            int y,
                            int width,
                            int height)
   {
      Color oldColor = g.getColor();

      g.setColor (getBorderColor());

      int newX[] = new int[5];
      int newY[] = new int[5];

      newX[0] = x;
      newX[1] = x + width / 2;
      newX[2] = x + width - 1;
      newX[3] = x + width / 2 - 1;
      newX[4] = x;

      newY[0] = y + height / 2;
      newY[1] = y;
      newY[2] = y + width / 2 - 1;
      newY[3] = y + height - 1;
      newY[4] = y + height / 2;

      g.setColor (FSAObject.COLOR_BACKGROUND);
      g.fillPolygon (newX, newY, 5);
      g.setColor (getBorderColor());
      g.drawPolyline (newX, newY, 5);

      g.setColor (oldColor);
   }
}

/*
 * $Log: RhombBorder.java,v $
 * Revision 1.11  2004/11/03 10:18:00  lowende
 * Javadoc warnings removed.
 *
 */
