/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import java.awt.*;

import javax.swing.border.Border;

import de.uni_paderborn.fujaba.fsa.FSAObject;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12 $
 */
public class CircleBorder extends AbstractColorBorder
{

   /**
    * Get the borderInsets attribute of the CircleBorder object
    *
    * @param c  No description provided
    * @return   The borderInsets value
    */
   public Insets getBorderInsets (Component c)
   {
      Dimension size = c.getSize();

      int radius = (int) size.getWidth() / 2;
      int innerRectWidth2 =  (new Double (radius / 1.4142135624)).intValue();

      return new Insets (radius - innerRectWidth2,
         radius - innerRectWidth2,
         radius - innerRectWidth2 + 1,
         radius - innerRectWidth2 + 1);
   }


   /**
    * Get the borderInsets attribute of the CircleBorder object
    *
    * @param c       No description provided
    * @param insets  No description provided
    * @return        The borderInsets value
    */
   public Insets getBorderInsets (Component c, Insets insets)
   {
      insets = getBorderInsets (c);
      return insets;
   }


   /**
    * Get the borderOpaque attribute of the CircleBorder object
    *
    * @return   The borderOpaque value
    */
   public boolean isBorderOpaque()
   {
      return false;
   }


   /**
    * Get the interiorRectangle attribute of the CircleBorder class
    *
    * @param c       No description provided
    * @param b       No description provided
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    * @return        The interiorRectangle value
    */
   public static Rectangle getInteriorRectangle (Component c, Border b,
                                                 int x, int y,
                                                 int width, int height)
   {
      int radius = width / 2;
      int innerRectWidth2 =  (new Double (radius / 1.4142135624)).intValue();

      return new Rectangle (radius - innerRectWidth2,
         y + height / 2 - innerRectWidth2,
         innerRectWidth2 * 2,
         innerRectWidth2 * 2);
   }



   /**
    * This method draws a circle around the component.
    *
    * @param c       No description provided
    * @param g       No description provided
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void paintBorder (Component c,
                            Graphics g,
                            int x,
                            int y,
                            int width,
                            int height)
   {
      Color oldColor = g.getColor();

      g.setColor (FSAObject.COLOR_FOREGROUND);
      g.drawArc (x, y, width - 1, height - 1, 0, 360);

      g.setColor (oldColor);
   }
}

/*
 * $Log: CircleBorder.java,v $
 * Revision 1.12  2004/11/03 10:18:00  lowende
 * Javadoc warnings removed.
 *
 */
