/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import java.awt.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.14 $
 */
public class ActivityBorder extends AbstractColorBorder
{
   /**
    * Constructor for class ActivityBorder
    */
   public ActivityBorder()
   {
      this (false);
   }


   /**
    * Constructor for class ActivityBorder
    *
    * @param foreachBorder  No description provided
    */
   public ActivityBorder (boolean foreachBorder)
   {
      super();
      this.setForeachBorder (foreachBorder);
   }


   /**
    * Get the borderInsets attribute of the ActivityBorder object
    *
    * @param c  No description provided
    * @return   The borderInsets value
    */
   public Insets getBorderInsets (Component c)
   {
      if (this.isForeachBorder())
      {
         return new Insets (11, 11, 1, 22);
      }
      else
      {
         return new Insets (1, 11, 1, 11);
      }
   }


   /**
    * Get the borderInsets attribute of the ActivityBorder object
    *
    * @param c       No description provided
    * @param insets  No description provided
    * @return        The borderInsets value
    */
   public Insets getBorderInsets (Component c, Insets insets)
   {
      insets = this.getBorderInsets (c);
      return insets;
   }


   /**
    * Get the borderOpaque attribute of the ActivityBorder object
    *
    * @return   The borderOpaque value
    */
   public boolean isBorderOpaque()
   {
      return false;
   }


   /**
    * This method draws the Border for Activities. It consists of a two lines at top and bottom
    * and the half of an ellipsoid at left and right. <pre>
    *  ----
    * (    )
    *  ----
    * </pre>
    *
    * @param c       No description provided
    * @param g       No description provided
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void paintBorder (Component c,
                            Graphics g,
                            int x,
                            int y,
                            int width,
                            int height)
   {
      Color oldColor = g.getColor();

      g.setColor (getBorderColor());

      if (this.isForeachBorder())
      {
         // draw a shadow shape
         g.drawLine (x + 20, y, x + width - 10 - 1, y);
         g.drawLine (x + 17, y + 10, x + 20, y);
         // g.drawArc (x+10, y, 20, 10, 9, 180);
         g.drawArc (x + width - 20 - 1, y, 20, height - 10, 90, -180);

         // shrink pane for normal shape
         width = width - 10;
         y = y + 10;
         height = height - 10;
      }

      // draw normal shape
      g.drawLine (x + 10, y, x + width - 10 - 1, y);
      g.drawLine (x + 10, y + height - 1, x + width - 10 - 1, y + height - 1);
      g.drawArc (x, y, 20, height, 90, 180);
      g.drawArc (x + width - 20 - 1, y, 20, height, 90, -180);

      g.setColor (oldColor);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean foreachBorder = false;


   /**
    * Get the foreachBorder attribute of the ActivityBorder object
    *
    * @return   The foreachBorder value
    */
   public boolean isForeachBorder()
   {
      return foreachBorder;
   }


   /**
    * Sets the foreachBorder attribute of the ActivityBorder object
    *
    * @param foreachBorder  The new foreachBorder value
    */
   public void setForeachBorder (boolean foreachBorder)
   {
      this.foreachBorder = foreachBorder;
   }
}

/*
 * $Log: ActivityBorder.java,v $
 * Revision 1.14  2004/10/20 17:49:49  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
