/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import javax.swing.*;

import de.uni_paderborn.fujaba.uml.UMLAttrExprPair;


/**
 * ComboBoxModel for UMLAttrExprPair.allAttrExprAsText
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.9 $
 */
public class UMLAttrExprOperationComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static String[] cache = UMLAttrExprPair.getAllAttrOperationsAsText();

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String selectedItem = null;


   /**
    * Default Constructor
    */
   public UMLAttrExprOperationComboBoxModel() { }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "UMLAttrExprOperationComboBoxModel";
   }


   /**
    * Get the selectedItem attribute of the UMLAttrExprOperationComboBoxModel object
    *
    * @return   The selectedItem value
    */
   public Object getSelectedItem()
   {
      return this.selectedItem;
   }


   /**
    * Sets the selectedItem attribute of the UMLAttrExprOperationComboBoxModel object
    *
    * @param value  The new selectedItem value
    */
   public void setSelectedItem (Object value)
   {
      if (this.selectedItem != value && value instanceof String)
      {
         this.selectedItem = (String) value;

         fireContentsChanged (this, -1, -1);
      }
   }


   /**
    * Get the elementAt attribute of the UMLAttrExprOperationComboBoxModel object
    *
    * @param index  No description provided
    * @return       The elementAt value
    */
   public Object getElementAt (int index)
   {
      return cache[index];
   }


   /**
    * Get the size attribute of the UMLAttrExprOperationComboBoxModel object
    *
    * @return   The size value
    */
   public int getSize()
   {
      return cache.length;
   }

}

/*
 * $Log: UMLAttrExprOperationComboBoxModel.java,v $
 * Revision 1.9  2004/11/03 10:17:59  lowende
 * Javadoc warnings removed.
 *
 */
