/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public class RoleLayout implements LayoutManager2
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int PAD = 3;


   /**
    * Constructor for class RoleLayout
    *
    * @param grab                No description provided
    * @param adornmentComponent  No description provided
    * @param roleComponent       No description provided
    * @param cardComponent       No description provided
    */
   public RoleLayout (JGrab grab, JComponent adornmentComponent, JComponent roleComponent, JComponent cardComponent)
   {
      this.grab = grab;
      this.adornmentComponent = adornmentComponent;
      this.roleComponent = roleComponent;
      this.cardComponent = cardComponent;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JComponent cardComponent;


   /**
    * Sets the cardComponent attribute of the RoleLayout object
    *
    * @param value  The new cardComponent value
    * @return       No description provided
    */
   public boolean setCardComponent (JComponent value)
   {
      if (this.cardComponent != value)
      {
         this.cardComponent = value;
         return true;
      }

      return false;
   }


   /**
    * Get the cardComponent attribute of the RoleLayout object
    *
    * @return   The cardComponent value
    */
   public JComponent getCardComponent()
   {
      return this.cardComponent;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JComponent roleComponent;


   /**
    * Sets the roleComponent attribute of the RoleLayout object
    *
    * @param value  The new roleComponent value
    * @return       No description provided
    */
   public boolean setRoleComponent (JComponent value)
   {
      if (this.roleComponent != value)
      {
         this.roleComponent = value;
         return true;
      }

      return false;
   }


   /**
    * Get the roleComponent attribute of the RoleLayout object
    *
    * @return   The roleComponent value
    */
   public JComponent getRoleComponent()
   {
      return this.roleComponent;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JComponent adornmentComponent;


   /**
    * Sets the adornmentComponent attribute of the RoleLayout object
    *
    * @param value  The new adornmentComponent value
    * @return       No description provided
    */
   public boolean setAdornmentComponent (JComponent value)
   {
      if (this.adornmentComponent != value)
      {
         this.adornmentComponent = value;
         return true;
      }

      return false;
   }


   /**
    * Get the adornmentComponent attribute of the RoleLayout object
    *
    * @return   The adornmentComponent value
    */
   public JComponent getAdornmentComponent()
   {
      return this.adornmentComponent;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JGrab grab;


   /**
    * Sets the grab attribute of the RoleLayout object
    *
    * @param value  The new grab value
    * @return       No description provided
    */
   public boolean setGrab (JGrab value)
   {
      if (this.grab != value)
      {
         this.grab = value;
         return true;
      }

      return false;
   }


   /**
    * Get the grab attribute of the RoleLayout object
    *
    * @return   The grab value
    */
   public JGrab getGrab()
   {
      return this.grab;
   }


   /**
    * Returns the amount of space the layout would like to have.
    *
    * @param parent  the Container for which this layout manager is being used
    * @return        a Dimension object containing the layout's preferred size
    */
   public Dimension preferredLayoutSize (Container parent)
   {
      Dimension adornDim = null;
      Dimension roleDim = null;
      Dimension cardDim = null;

      if (adornmentComponent != null &&
      /*
       *  adornmentComponent.isVisible() &&
       */
         adornmentComponent.getParent() == parent)
      {
         adornDim = adornmentComponent.getPreferredSize();
      }
      if (roleComponent != null && roleComponent.isVisible() && roleComponent.getParent() == parent)
      {
         roleDim = roleComponent.getPreferredSize();
      }
      if (cardComponent != null && cardComponent.isVisible() && cardComponent.getParent() == parent)
      {
         cardDim = cardComponent.getPreferredSize();
      }
      return calculateSize (parent, adornDim, roleDim, cardDim);
   }


   /**
    * Returns the minimum amount of space the layout needs.
    *
    * @param parent  the Container for which this layout manager is being used
    * @return        a Dimension object containing the layout's minimum size
    */
   public Dimension minimumLayoutSize (Container parent)
   {
      return preferredLayoutSize (parent);
      /*
       *  Dimension adornDim=null;
       *  Dimension roleDim=null;
       *  Dimension cardDim=null;
       *  if(adornmentComponent != null && adornmentComponent.isVisible())
       *  {
       *  adornDim = adornmentComponent.getMinimumSize();
       *  }
       *  if(roleComponent != null && roleComponent.isVisible())
       *  {
       *  roleDim = roleComponent.getMinimumSize();
       *  }
       *  if(cardComponent != null && cardComponent.isVisible())
       *  {
       *  cardDim = cardComponent.getMinimumSize();
       *  }
       *  return calculateSize(parent adornDim, roleDim, cardDim);
       */
   }


   /**
    * Returns the maximum amount of space the layout can use.
    *
    * @param parent  No description provided
    * @return        a Dimension object containing the layout's maximum size
    */
   public Dimension maximumLayoutSize (Container parent)
   {
      return preferredLayoutSize (parent);
      /*
       *  Dimension adornDim=null;
       *  Dimension roleDim=null;
       *  Dimension cardDim=null;
       *  if(adornmentComponent != null && adornmentComponent.isVisible())
       *  {
       *  adornDim = adornmentComponent.getMaximumSize();
       *  }
       *  if(roleComponent != null && roleComponent.isVisible())
       *  {
       *  roleDim = roleComponent.getMaximumSize();
       *  }
       *  if(cardComponent != null && cardComponent.isVisible())
       *  {
       *  cardDim = cardComponent.getMaximumSize();
       *  }
       *  return calculateSize(parent, adornDim, roleDim, cardDim);
       */
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent    No description provided
    * @param adornDim  No description provided
    * @param roleDim   No description provided
    * @param cardDim   No description provided
    * @return          No description provided
    */
   protected Dimension calculateSize (Container parent, Dimension adornDim, Dimension roleDim, Dimension cardDim)
   {
      Dimension result = new Dimension();
      Insets insets = parent.getInsets();
      Direction orient = grab.getOrientation();

      int adornWidth;
      int adornHeight;
      int roleWidth;
      int roleHeight;
      int cardWidth;
      int cardHeight;

      if (adornDim == null)
      {
         adornWidth = 0;
         adornHeight = 0;
      }
      else
      {
         adornWidth = adornDim.width;
         adornHeight = adornDim.height;
      } // else

      if (roleDim == null)
      {
         roleWidth = 0;
         roleHeight = 0;
      }
      else
      {
         roleWidth = roleDim.width;
         roleHeight = roleDim.height;
      } // else

      if (cardDim == null)
      {
         cardWidth = 0;
         cardHeight = 0;
      }
      else
      {
         cardWidth = cardDim.width;
         cardHeight = cardDim.height;
      } // else

      if (orient == Direction.TOP)
      {
         if (roleWidth != 0)
         {
            roleWidth += PAD;
         }
         if (cardWidth != 0)
         {
            cardWidth += PAD;
         }
         if (adornWidth != 0)
         {
            adornWidth = (int) Math.ceil (adornWidth / 2);
         }
         result.width = Math.max (roleWidth, adornWidth) +
            Math.max (cardWidth, adornWidth) +
            insets.left + insets.right;

         result.height = adornHeight + insets.top + insets.bottom;
         if (cardHeight != 0 || roleHeight != 0)
         {
            result.height += Math.max (roleHeight, cardHeight) + PAD;
         }
      }
      else
      {
         if (roleHeight != 0)
         {
            roleHeight += PAD;
         }
         if (cardHeight != 0)
         {
            cardHeight += PAD;
         }
         if (adornHeight != 0)
         {
            adornHeight = (int) Math.ceil (adornHeight / 2);
         }
         result.height = Math.max (roleHeight, adornHeight) +
            Math.max (cardHeight, adornHeight) +
            insets.top + insets.bottom;

         result.width = adornWidth + insets.left + insets.right;
         if (cardWidth != 0 || roleWidth != 0)
         {
            result.width += Math.max (roleWidth, cardWidth) + PAD;
         }
      } // else

      return result;
   }


   /**
    * Instructs the layout manager to perform the layout for the specified container.
    *
    * @param parent  No description provided
    */
   public void layoutContainer (Container parent)
   {
      Rectangle bounds = parent.getBounds();
      Insets insets = parent.getInsets();
      Direction orient = grab.getOrientation();

      Dimension adornDim = null;
      Dimension roleDim = null;
      Dimension cardDim = null;

      if (adornmentComponent != null &&
      /*
       *  adornmentComponent.isVisible() &&
       */
         adornmentComponent.getParent() == parent)
      {
         adornDim = adornmentComponent.getPreferredSize();
         adornmentComponent.setSize (adornDim);
      }
      if (roleComponent != null && roleComponent.isVisible() && roleComponent.getParent() == parent)
      {
         roleDim = roleComponent.getPreferredSize();
         roleComponent.setSize (roleDim);
      }
      if (cardComponent != null && cardComponent.isVisible() && cardComponent.getParent() == parent)
      {
         cardDim = cardComponent.getPreferredSize();
         cardComponent.setSize (cardDim);
      }

      Dimension preferredDim = calculateSize (parent, adornDim, roleDim, cardDim);
      int xOff = 0;
      int yOff = 0;
      int center = 0;
      int alignOffset = 0;

      if (orient == Direction.TOP || orient == Direction.BOTTOM)
      {
         xOff =  (bounds.width - preferredDim.width - insets.left - insets.right) / 2 + insets.left;
         center = xOff;
         if (roleDim != null)
         {
            center = xOff + roleDim.width + PAD;
         }
         if (adornDim != null)
         {
            center = Math.max (center, xOff + adornDim.width / 2);
         } // else

         if (orient == Direction.TOP)
         {
            if (adornDim != null)
            {
               alignOffset = bounds.height - adornDim.height - insets.bottom;
            }
            else
            {
               alignOffset = bounds.height - insets.bottom;
            }
         }
         else
         {
            if (adornDim != null)
            {
               alignOffset = insets.top + adornDim.height;
            }
            else
            {
               alignOffset = insets.top;
            }
         }
      }
      else
      {
         yOff =  (bounds.height - preferredDim.height - insets.top - insets.bottom) / 2 + insets.top;
         center = yOff;
         if (roleDim != null)
         {
            center = yOff + roleDim.height + PAD;
         }
         if (adornDim != null)
         {
            center = Math.max (center, yOff + adornDim.height / 2);
         } // else

         if (orient == Direction.LEFT)
         {
            if (adornDim != null)
            {
               alignOffset = bounds.width - adornDim.width - insets.right;
            }
            else
            {
               alignOffset = bounds.width - insets.right;
            }
         }
         else
         {
            if (adornDim != null)
            {
               alignOffset = insets.right + adornDim.width;
            }
            else
            {
               alignOffset = insets.right;
            }
         }
      } // else

      if (adornDim != null)
      {
         if (orient == Direction.TOP)
         {
            adornmentComponent.setLocation (center - adornDim.width / 2, alignOffset);
         }
         else if (orient == Direction.BOTTOM)
         {
            adornmentComponent.setLocation (center - adornDim.width / 2, insets.top);
         }
         else if (orient == Direction.LEFT)
         {
            adornmentComponent.setLocation (alignOffset, center - adornDim.height / 2);
         }
         else if (orient == Direction.RIGHT)
         {
            adornmentComponent.setLocation (insets.left, center - adornDim.height / 2);
         }
      }

      if (roleDim != null)
      {
         if (orient == Direction.TOP)
         {
            roleComponent.setLocation (center - roleDim.width - PAD, alignOffset - PAD - roleDim.height);
         }
         else if (orient == Direction.BOTTOM)
         {
            roleComponent.setLocation (center - roleDim.width - PAD, alignOffset + PAD);
         }
         else if (orient == Direction.LEFT)
         {
            roleComponent.setLocation (alignOffset - PAD - roleDim.width, center - roleDim.height - PAD);
         }
         else if (orient == Direction.RIGHT)
         {
            roleComponent.setLocation (alignOffset + PAD, center - roleDim.height - PAD);
         }
      }
      if (cardDim != null)
      {
         if (orient == Direction.TOP)
         {
            cardComponent.setLocation (center + PAD, alignOffset - PAD - cardDim.height);
         }
         else if (orient == Direction.BOTTOM)
         {
            cardComponent.setLocation (center + PAD, alignOffset + PAD);
         }
         else if (orient == Direction.LEFT)
         {
            cardComponent.setLocation (alignOffset - PAD - cardDim.width, center + PAD);
         }
         else if (orient == Direction.RIGHT)
         {
            cardComponent.setLocation (alignOffset + PAD, center + PAD);
         }
      }

      Component[] children = parent.getComponents();
      for (int i = 0; i < children.length; i++)
      {
         if (children[i].isVisible() && children[i] != adornmentComponent &&
            children[i] != cardComponent && children[i] != roleComponent)
         {
            children[i].setSize (children[i].getPreferredSize());
         }
      } // for
   }


   /**
    * Access method for an one to n association.
    *
    * @param name  The object added.
    * @param comp  The object added.
    */
   public void addLayoutComponent (String name, Component comp) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comp  No description provided
    */
   public void removeLayoutComponent (Component comp) { }


   /**
    * Access method for an one to n association.
    *
    * @param comp         The object added.
    * @param constraints  The object added.
    */
   public void addLayoutComponent (Component comp, Object constraints) { }


   /**
    * Get the layoutAlignmentX attribute of the RoleLayout object
    *
    * @param target  No description provided
    * @return        The layoutAlignmentX value
    */
   public float getLayoutAlignmentX (Container target)
   {
      return 0.0f;
   }


   /**
    * Get the layoutAlignmentY attribute of the RoleLayout object
    *
    * @param target  No description provided
    * @return        The layoutAlignmentY value
    */
   public float getLayoutAlignmentY (Container target)
   {
      return 0.0f;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    */
   public void invalidateLayout (Container target) { }
}

/*
 * $Log: RoleLayout.java,v $
 * Revision 1.11  2004/11/03 10:17:59  lowende
 * Javadoc warnings removed.
 *
 */
