/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;
import java.util.Iterator;

import javax.swing.*;


/**
 * THE choice for targets with a RhombBorder
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 * @see       de.uni_paderborn.fujaba.fsa.swing.border.RhombBorder
 */
public class RhombGrabLayouter extends GrabLayouter
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static RhombGrabLayouter layouter = null;


   /**
    * Constructor for class RhombGrabLayouter
    */
   private RhombGrabLayouter()
   {
      super();
   }


   /**
    * @return   the singleton instance
    */
   public static GrabLayouter get()
   {
      if (layouter == null)
      {
         layouter = new RhombGrabLayouter();
      }

      return layouter;
   }


   /**
    * layout all the grabs of manager currently the grabs are simply set to their preferred
    * location as determined by layoutGrab and getPreferredLayoutInformation. Overlapping is
    * not handled
    *
    * @param manager  No description provided
    * @see            de.uni_paderborn.fujaba.fsa.swing.GrabLayouter#getPreferredLayoutInformation
    * @see            #layoutGrab
    */
   public void layout (GrabManager manager)
   {
      Iterator grabIter = manager.iteratorOfGrabs();
      while (grabIter.hasNext())
      {
         JGrab grab = (JGrab) grabIter.next();
         layoutGrab (manager, grab);
      }
   }


   /**
    * puts the grab to one of the corners of the Rhomb according to the preferred orientation
    *
    * @param manager  No description provided
    * @param grab     No description provided
    */
   protected void layoutGrab (GrabManager manager, JGrab grab)
   {
      Rectangle bounds = manager.getTarget().getBounds();
      double[] info = getPreferredLayoutInformation (grab);
      Direction orientation = Direction.fromInt ((int) info[0]);

      Point grabPoint = new Point();
      Rectangle grabBounds = grab.getBounds();
      if (orientation == Direction.TOP)
      {
         grabPoint.x = bounds.x + (int)  ( ((double)  (bounds.width - grabBounds.width)) / 2);
         grabPoint.y = bounds.y - grabBounds.height + 1;
      }
      else if (orientation == Direction.BOTTOM)
      {
         grabPoint.x = bounds.x + (int)  ( ((double)  (bounds.width - grabBounds.width)) / 2);
         grabPoint.y = bounds.y + bounds.height - 1;
      }
      else if (orientation == Direction.LEFT)
      {
         grabPoint.x = bounds.x - grabBounds.width + 1;
         grabPoint.y = bounds.y + (int)  ( ((double)  (bounds.height - grabBounds.height)) / 2);
      }
      else
      {
         grabPoint.x = bounds.x + bounds.width - 1;
         grabPoint.y = bounds.y + (int)  ( ((double)  (bounds.height - grabBounds.height)) / 2);
      }
      Container targetParent = manager.getTarget().getParent();
      Container grabParent = grab.getParent();
      if (targetParent != null && grabParent != null)
      {
         grabPoint = SwingUtilities.convertPoint (targetParent, grabPoint, grabParent);
      }

      grab.setLocation (grabPoint);
   }
}

/*
 * $Log: RhombGrabLayouter.java,v $
 * Revision 1.11  2004/11/03 10:17:59  lowende
 * Javadoc warnings removed.
 *
 */
