/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.util.*;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 */
public class RepresentationComboBoxModel extends DefaultComboBoxModel
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private HashMap representations = new HashMap();


   /**
    * sets the representation that is used instead of the given Object itself
    *
    * @param data            The object added.
    * @param representation  The object added.
    * @see                   #getFromRepresentations
    */
   public void addToRepresentations (Object data, Object representation)
   {
      if (representation == null || representation.equals (data))
      {
         representations.remove (data);
      }
      else
      {
         representations.put (data, representation);
      }
   }


   /**
    * @param data  No description provided
    * @return      the Object that represents the given Object or the Object itself if no representation
    *      is found
    */
   public Object getFromRepresentations (Object data)
   {
      Object result = representations.get (data);

      if (result == null)
      {
         result = data;
      }

      return result;
   }


   /**
    * @param data  No description provided
    * @return      true if a representation is bound to the given Object
    * @see         #getFromRepresentations
    */
   public boolean hasInRepresentations (Object data)
   {
      return representations.containsKey (data);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param data  No description provided
    */
   public void removeFromRepresentations (Object data)
   {
      representations.remove (data);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRepresentations()
   {
      Iterator reprIter = representations.keySet().iterator();
      while (reprIter.hasNext())
      {
         reprIter.remove();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      removeAllFromRepresentations();
   }


   /**
    * Get the elementAt attribute of the RepresentationComboBoxModel object
    *
    * @param index  No description provided
    * @return       The elementAt value
    */
   public Object getElementAt (int index)
   {
      Object element = super.getElementAt (index);

      return getFromRepresentations (element);
   }


   /**
    * Get the indexOf attribute of the RepresentationComboBoxModel object
    *
    * @param anObject  No description provided
    * @return          The indexOf value
    */
   public int getIndexOf (Object anObject)
   {
      int index = super.getIndexOf (anObject);

      if (index > -1)
      {
         return index;
      }

      Iterator entryIter = representations.entrySet().iterator();

      while (entryIter.hasNext())
      {
         Map.Entry entry = (Map.Entry) entryIter.next();

         if ( (anObject == null && entry.getValue() == null) ||
             (anObject != null && anObject.equals (entry.getValue())))
         {
            return super.getIndexOf (entry.getKey());
         }
      }

      return -1;
   }


   /**
    * Get the selectedItem attribute of the RepresentationComboBoxModel object
    *
    * @return   The selectedItem value
    */
   public Object getSelectedItem()
   {
      return getFromRepresentations (super.getSelectedItem());
   }


   /**
    * Sets the selectedItem attribute of the RepresentationComboBoxModel object
    *
    * @param anObject  The new selectedItem value
    */
   public void setSelectedItem (Object anObject)
   {
      super.setSelectedItem (getFromRepresentations (anObject));
   }
}

/*
 * $Log: RepresentationComboBoxModel.java,v $
 * Revision 1.10  2004/10/20 17:49:47  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
