/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;


/**
 * Grab UI that has a component as representation for the grab itself and can contain additional
 * elements which are layouted around the line that is attached to the grab
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.16 $
 */
public class PanelGrabUI extends DefaultGrabUI
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param c  No description provided
    * @return   No description provided
    */
   public static ComponentUI createUI (JComponent c)
   {
      return new PanelGrabUI();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JBend bend;


   /**
    * Get the bend attribute of the PanelGrabUI object
    *
    * @return   The bend value
    */
   public JBend getBend()
   {
      return bend;
   }


   /**
    * Sets the bend attribute of the PanelGrabUI object
    *
    * @param bend  The new bend value
    * @return      No description provided
    */
   public boolean setBend (JBend bend)
   {
      if (bend != this.bend)
      {
         if (this.bend != null)
         {
            this.bend.setUI (null);
         }
         this.bend = bend;
         if (bend != null)
         {
            if (bend.getUI() != this)
            {
               bend.setUI (this);
            }
         }
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JComponent grabComponent = null;


   /**
    * Sets the grabComponent attribute of the PanelGrabUI object
    *
    * @param c  The new grabComponent value
    */
   public void setGrabComponent (JComponent c)
   {
      if (this.grabComponent != c)
      {
         if (this.grabComponent != null && bend != null)
         {
            bend.remove (this.grabComponent);
         }
         this.grabComponent = c;

         if (c != null)
         {
            Container parent = c.getParent();
            if (parent != bend)
            {
               if (parent != null)
               {
                  parent.remove (c);
               }
               if (bend != null)
               {
                  bend.add (c, new GrabConstraints ((JGrab) bend));
               }
            }
         }

         if (bend != null)
         {
            bend.resetPoint();
            bend.revalidate();
         }
      }
   }


   /**
    * Get the grabComponent attribute of the PanelGrabUI object
    *
    * @return   The grabComponent value
    */
   public JComponent getGrabComponent()
   {
      return grabComponent;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param c  No description provided
    */
   public void installUI (JComponent c)
   {
      super.installUI (c);
      setBend ((JBend) c);

      installDefaults();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param c  No description provided
    */
   public void uninstallUI (JComponent c)
   {
      if (c == bend)
      {
         super.uninstallUI (c);
         c.removeAll();
         bend = null;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void installDefaults()
   {
      bend.setOpaque (false);
      bend.setBorder (new EmptyBorder (0, 0, 0, 0));

      if (grabComponent != null)
      {
         JComponent tmp = grabComponent;
         grabComponent = null;
         setGrabComponent (tmp);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param c  No description provided
    * @return   No description provided
    */
   protected Point calculatePoint (JComponent c)
   {
      Point result = null;
      if (c instanceof JGrab && c.isVisible())
      {
         Rectangle bounds = null;
         Direction orientation =  ((JGrab) c).getOrientation();
         if (grabComponent == null || !grabComponent.isVisible())
         {
            orientation = orientation.reverse();
         }

         if (grabComponent != null)
         {
            if (grabComponent.getComponentCount() > 0)
            {
               Component comp =  ((JPanel) grabComponent).getComponent (0);
               if (comp instanceof JArrowHead)
               {
                   ((JArrowHead) comp).setDirection (orientation.reverse());
               }
            }
            result = c.getLocation();
            bounds = grabComponent.getBounds();
         }
         else
         {
            result = new Point (0, 0);
            bounds = c.getBounds();
         } // else

         if (orientation == Direction.LEFT)
         {
            result.x += bounds.x;
            result.y += bounds.y + bounds.height / 2;
         }
         else if (orientation == Direction.RIGHT)
         {
            result.x += bounds.x + bounds.width - 1;
            result.y += bounds.y + bounds.height / 2;
         }
         else if (orientation == Direction.BOTTOM)
         {
            result.x += bounds.x + bounds.width / 2;
            result.y += bounds.y + bounds.height - 1;
         }
         else
         {
            result.x += bounds.x + bounds.width / 2;
            result.y += bounds.y;
         }
      }
      else
      {
         result = super.calculatePoint (c);
      }

      return result;
   }


   /**
    * Get the touchOffset attribute of the PanelGrabUI object
    *
    * @param g  No description provided
    * @return   The touchOffset value
    */
   protected int getTouchOffset (JGrab g)
   {
      if (grabComponent != null)
      {
         if (g.getOrientation() == Direction.LEFT || g.getOrientation() == Direction.RIGHT)
         {
            return grabComponent.getY();
         }
         else
         {
            return grabComponent.getX();
         }
      }
      else
      {
         return super.getTouchOffset (g);
      } // else
   }


   /**
    * Get the touchLength attribute of the PanelGrabUI object
    *
    * @param g  No description provided
    * @return   The touchLength value
    */
   protected int getTouchLength (JGrab g)
   {
      if (grabComponent != null)
      {
         if (g.getOrientation() == Direction.LEFT || g.getOrientation() == Direction.RIGHT)
         {
            return grabComponent.getHeight();
         }
         else
         {
            return grabComponent.getWidth();
         }
      }
      else
      {
         return super.getTouchLength (g);
      } // else
   }


   /**
    * Get the alignmentOffset attribute of the PanelGrabUI object
    *
    * @param g  No description provided
    * @return   The alignmentOffset value
    */
   protected int getAlignmentOffset (JGrab g)
   {
      if (grabComponent != null)
      {
         Rectangle bounds = grabComponent.getBounds();
         if (g.getOrientation() == Direction.LEFT || g.getOrientation() == Direction.RIGHT)
         {
            return bounds.y + bounds.height / 2;
         }
         else
         {
            return bounds.x + bounds.width / 2;
         }
      }
      else
      {
         return super.getAlignmentOffset (g);
      } // else
   }


   /**
    * Get the minimumSize attribute of the PanelGrabUI object
    *
    * @param c  No description provided
    * @return   The minimumSize value
    */
   public Dimension getMinimumSize (JComponent c)
   {
      return null; //let LayoutManager decide
   }


   /**
    * Get the maximumSize attribute of the PanelGrabUI object
    *
    * @param c  No description provided
    * @return   The maximumSize value
    */
   public Dimension getMaximumSize (JComponent c)
   {
      return null; //let LayoutManager decide
   }


   /**
    * Get the preferredSize attribute of the PanelGrabUI object
    *
    * @param c  No description provided
    * @return   The preferredSize value
    */
   public Dimension getPreferredSize (JComponent c)
   {
      return null; //let LayoutManager decide
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param c  No description provided
    * @param x  No description provided
    * @param y  No description provided
    * @return   No description provided
    */
   public boolean contains (JComponent c, int x, int y)
   {
      Rectangle bounds = c.getBounds();

      if (x < 0 || bounds.width <= x || y < 0 || bounds.height <= y)
      {
         return false;
      }
      if (c.isOpaque())
      {
         return true;
      }
      Component[] children = c.getComponents();
      int xOff;
      int yOff;
      for (int i = 0; i < children.length; i++)
      {
         if (children[i].isVisible())
         {
            xOff = children[i].getX();
            yOff = children[i].getY();

            if (children[i].contains (x - xOff, y - yOff))
            {
               return true;
            }
         }
      } // for
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param g  No description provided
    * @param c  No description provided
    */
   public void paint (Graphics g, JComponent c) { }
}

/*
 * $Log: PanelGrabUI.java,v $
 * Revision 1.16  2004/11/03 10:17:59  lowende
 * Javadoc warnings removed.
 *
 */
