/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;


/**
 * Renders icons for operations such as equal, not equal, etc. This class uses a singleton
 * pattern, see OperationIcon.get().
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public class OperationIcon implements Icon
{
   /**
    * Creates a new operation icon with the given shape. The constructor is private, because
    * this class is a singleton, use get() for obtaining instances of this class.
    *
    * @param shape  shape to use for this icon.
    */

   private OperationIcon (int shape)
   {
      this.shape = shape;
   }


   /**
    * flags for appearance and types
    */
   public final static transient int EQUAL = 0;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int NONEQUAL = 1;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int LSUBSET = 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int RSUBSET = 3;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int LSUBSETEQUAL = 4;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int RSUBSETEQUAL = 5;

   /**
    * The number of icons supported by this class.
    */

   private final static transient int NUM_ICONS = 6;

   /**
    * Stores the instances of this class. For each icon supported of this class, one instance
    * is stored.
    */

   private static OperationIcon instances[] = new OperationIcon[NUM_ICONS];


   /**
    * Returns an instance of this class with the given shape. The OperationIcon returned is
    * a singleton and may thus be shared for multiple tasks. The OperationIcon returned is
    * immutable.
    *
    * @param shape  shape to use for this icon.
    * @return       an instance of this class with the given shape.
    */

   public static OperationIcon get (int shape)
   {
      if (instances[shape] == null)
      {
         instances[shape] = new OperationIcon (shape);
      }

      return instances[shape];
   }


   /**
    * The shape of this icon
    */

   private int shape;


   /**
    * Returns the shape of this icon
    *
    * @return   the shape of this icon
    */

   public int getShape()
   {
      return shape;
   } // getShape


   /**
    * Returns the width of this icon
    *
    * @return   the width of this icon
    */
   public int getIconWidth()
   {
      return 20;
   }


   /**
    * Returns the height of this icon
    *
    * @return   the height of this icon
    */
   public int getIconHeight()
   {
      return 20;
   }


   /**
    * Paints this icon at the given position
    *
    * @param c  No description provided
    * @param g  No description provided
    * @param x  No description provided
    * @param y  No description provided
    */
   public void paintIcon (Component c, Graphics g, int x, int y)
   {
      int width = getIconWidth();
      int height = getIconHeight();

      Color oldPenColor = g.getColor();

      g.setColor (c.getForeground());

      try
      {

         // paint the sign for the operation

         switch (shape)
         {
            case EQUAL:
            case NONEQUAL:
               g.drawLine (5, 7, width - 5, 7);
               g.drawLine (5, 8, width - 5, 8);
               g.drawLine (5, height - 7, width - 5, height - 7);
               g.drawLine (5, height - 8, width - 5, height - 8);

               if (shape == NONEQUAL)
               {
                  g.drawLine (width / 2 + 3, 2, width / 2 - 2, height - 2);
                  g.drawLine (width / 2 + 2, 2, width / 2 - 3, height - 2);
               }
               break;
            case LSUBSET:
               g.drawArc (2, 4, width / 2, height / 2, 90, 180);
               g.drawArc (3, 5, width / 2, height / 2, 90, 180);
               g.drawArc (2, 5, width / 2, height / 2, 90, 180);
               g.drawArc (3, 4, width / 2, height / 2, 90, 180);
               g.drawLine ( (width / 2) - 1, 4, width - 4, 4);
               g.drawLine ( (width / 2) - 1, 5, width - 4, 5);
               g.drawLine ( (width / 2) - 1, 4 +  (height / 2), width - 4, 4 +  (height / 2));
               g.drawLine ( (width / 2) - 1, 5 +  (height / 2), width - 4, 5 +  (height / 2));
               break;
            case LSUBSETEQUAL:
               g.drawArc (2, 2, width / 2, height / 2, 90, 180);
               g.drawArc (3, 3, width / 2, height / 2, 90, 180);
               g.drawArc (2, 3, width / 2, height / 2, 90, 180);
               g.drawArc (3, 2, width / 2, height / 2, 90, 180);
               g.drawLine ( (width / 2) - 1, 2, width - 4, 2);
               g.drawLine ( (width / 2) - 1, 3, width - 4, 3);
               g.drawLine ( (width / 2) - 1, 2 +  (height / 2), width - 4, 2 +  (height / 2));
               g.drawLine ( (width / 2) - 1, 3 +  (height / 2), width - 4, 3 +  (height / 2));
               g.drawLine (2, height - 3, width - 4, height - 3);
               g.drawLine (2, height - 2, width - 4, height - 2);
               break;
            case RSUBSET:
               g.drawArc (width / 2 - 2, 4, width / 2, height / 2, 270, 180);
               g.drawArc (width / 2 - 3, 4, width / 2, height / 2, 270, 180);
               g.drawArc (width / 2 - 2, 5, width / 2, height / 2, 270, 180);
               g.drawArc (width / 2 - 3, 5, width / 2, height / 2, 270, 180);
               g.drawLine (4, 4, 2 +  (width / 2), 4);
               g.drawLine (4, 5, 2 +  (width / 2), 5);
               g.drawLine (4, 4 +  (height / 2), 2 +  (width / 2), 4 +  (height / 2));
               g.drawLine (4, 5 +  (height / 2), 2 +  (width / 2), 5 +  (height / 2));
               break;
            case RSUBSETEQUAL:
               g.drawArc (width / 2 - 2, 2, width / 2, height / 2, 270, 180);
               g.drawArc (width / 2 - 3, 2, width / 2, height / 2, 270, 180);
               g.drawArc (width / 2 - 2, 3, width / 2, height / 2, 270, 180);
               g.drawArc (width / 2 - 3, 3, width / 2, height / 2, 270, 180);
               g.drawLine (4, 2, 2 +  (width / 2), 2);
               g.drawLine (4, 3, 2 +  (width / 2), 3);
               g.drawLine (4, 2 +  (height / 2), 2 +  (width / 2), 2 +  (height / 2));
               g.drawLine (4, 3 +  (height / 2), 2 +  (width / 2), 3 +  (height / 2));
               g.drawLine (4, height - 3, width - 3, height - 3);
               g.drawLine (4, height - 2, width - 3, height - 2);
               break;
         }
      }
      finally
      {
         g.setColor (oldPenColor);
      }
   } // paintIcon

}

/*
 * $Log: OperationIcon.java,v $
 * Revision 1.11  2004/11/03 10:17:58  lowende
 * Javadoc warnings removed.
 *
 */
