/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;


/**
 * layout container with one element
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.10 $
 */
public class OneElementLayouter
    implements LayoutManager
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static OneElementLayouter layouter = null;


   /**
    * Default Constructor
    */
   private OneElementLayouter() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static OneElementLayouter get()
   {
      if (layouter == null)
      {
         layouter = new OneElementLayouter();
      } // end of if ()
      return layouter;
   }


   /**
    * Access method for an one to n association.
    *
    * @param name  The object added.
    * @param comp  The object added.
    */
   public void addLayoutComponent (String name, Component comp)
   {

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param container  No description provided
    */
   public void layoutContainer (Container container)
   {
      synchronized (container.getTreeLock())
      {
         Insets insets = container.getInsets();

         int count = container.getComponentCount();

         if (count > 1)
         {
            throw new RuntimeException (this + ".layoutContainer ( " +
               container + " ) : getComponentCount() > 1 ");
         }

         if (count == 1)
         {
            container.getComponent (0).setBounds (insets.left,
               insets.top,
               container.getWidth() - insets.left - insets.right,
               container.getHeight() - insets.top - insets.bottom);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param container  No description provided
    * @return           No description provided
    */
   public Dimension minimumLayoutSize (Container container)
   {
      synchronized (container.getTreeLock())
      {
         Insets insets = container.getInsets();

         int count = container.getComponentCount();

         if (count > 1)
         {
            throw new RuntimeException (this + ".minimumLayoutSize ( " +
               container + " ) : getComponentCount() > 1 ");
         }

         Dimension minDim = new Dimension (0, 0);

         if (count == 1)
         {
            minDim = container.getComponent (0).getMinimumSize();
         }

         return new Dimension (insets.left + insets.right + minDim.width,
            insets.top + insets.bottom + minDim.height);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param container  No description provided
    * @return           No description provided
    */
   public Dimension preferredLayoutSize (Container container)
   {
      synchronized (container.getTreeLock())
      {
         Insets insets = container.getInsets();

         int count = container.getComponentCount();

         if (count > 1)
         {
            throw new RuntimeException (this + ".preferredLayoutSize ( " +
               container + " ) : getComponentCount() > 1 ");
         }

         Dimension prefDim = new Dimension (0, 0);

         if (count == 1)
         {
            prefDim = container.getComponent (0).getPreferredSize();
         }

         return new Dimension (insets.left + insets.right + prefDim.width,
            insets.top + insets.bottom + prefDim.height);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comp  No description provided
    */
   public void removeLayoutComponent (Component comp)
   {

   }

}

/*
 * $Log: OneElementLayouter.java,v $
 * Revision 1.10  2004/11/03 10:17:58  lowende
 * Javadoc warnings removed.
 *
 */
