/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;


/**
 * $Id: LifeLineLayout.java,v 1.8 2004/10/20 17:49:47 schneider Exp $ This LayoutManager layouts
 * the components in a column or a row without changing their sizes. This LayoutManager was
 * written as an replacement for the GridLayout with one row or one column.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.8 $
 */
public class LifeLineLayout extends Object implements LayoutManager
{
   /**
    * Constructor for class LifeLineLayout
    */
   public LifeLineLayout()
   {
      super();
   }


   /**
    * Access method for an one to n association.
    *
    * @param name  The object added.
    * @param comp  The object added.
    */
   public void addLayoutComponent (String name, Component comp)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comp  No description provided
    */
   public void removeLayoutComponent (Component comp)
   {
   }


   /**
    * This method calculates the preferredSize of the Container. Between the objects and around
    * them is the gap.
    *
    * @param parent  No description provided
    * @return        No description provided
    */

   public Dimension preferredLayoutSize (Container parent)
   {
      Component comp[] = parent.getComponents();
      Insets insets = parent.getInsets();
      int i;
      int height = 0;
      int width = 0;
      Dimension tempDim;
      int compCount = 0;

      for (i = 0; i < comp.length; i++)
      {
         if (!comp[i].isVisible())
         {
            continue;
         }

         compCount++;

         tempDim = comp[i].getPreferredSize();

         if (tempDim.width > width)
         {
            width = tempDim.width;
         }

         height = height + tempDim.height;
      }

      return new Dimension (width + insets.left + insets.right, height + insets.top + insets.bottom);
   }


   /**
    * The minimumLayout Size is for this LayoutManager the same as the preferredLayoutSize.
    *
    * @param parent  No description provided
    * @return        No description provided
    */

   public Dimension minimumLayoutSize (Container parent)
   {
      return preferredLayoutSize (parent);
   }


   /**
    * This method moves the objects to their places and set the sizes they prefer.
    *
    * @param parent  No description provided
    */

   public void layoutContainer (Container parent)
   {
      Component comp[] = parent.getComponents();
      Insets insets = parent.getInsets();

      int x = insets.left;
      int y = insets.top;

      int i;
      Dimension dim = preferredLayoutSize (parent);

      int maxWidth = dim.width - insets.left - insets.right;

      Dimension tempDim;

      for (i = 0; i < comp.length; i++)
      {
         if (!comp[i].isVisible())
         {
            continue;
         }

         if (comp[i] instanceof JLifeLineSegment)
         {
            int llWidth =  ((JLifeLineSegment) comp[i]).getPreferredSize().width;

            //int llx = (maxWidth - JLifeLineSegment.columnWidth) / 2;
            int llx =  (maxWidth - llWidth) / 2;
            comp[i].setLocation (llx, y);
         }
         else
         {
            comp[i].setLocation (x, y);
         }

         tempDim = comp[i].getPreferredSize();

         if (comp[i] instanceof JLifeLineSegment)
         {
            int llWidth =  ((JLifeLineSegment) comp[i]).getPreferredSize().width;
            comp[i].setSize (llWidth + 2, tempDim.height);
         }
         else
         {
            comp[i].setSize (maxWidth, tempDim.height);
         }

         y = y + tempDim.height;
      }

   }
}

/*
 * $Log: LifeLineLayout.java,v $
 * Revision 1.8  2004/10/20 17:49:47  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
