/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;


/**
 * @author    $Author: lowende $
 * @version   $Revision: 1.15 $
 */
public class JUnderlinedPanel
    extends JBoundsPanel
{
   /**
    * Constructor for class JUnderlinedPanel
    */
   public JUnderlinedPanel()
   {
      super();
   }


   /**
    * UMLAttribute : 'editing : Boolean '
    */
   private boolean underlined = false;


   /**
    * Get the value of editing.
    *
    * @return   Value of editing.
    */
   public boolean isUnderlined()
   {
      return this.underlined;
   }


   /**
    * Set the value of editing.
    *
    * @param underlined  The new underlined value
    */
   public void setUnderlined (boolean underlined)
   {
      if (this.underlined != underlined)
      {
         this.underlined = underlined;
         validate();
         repaint();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Insets lineInsets = null;


   /**
    * Get the lineInsets attribute of the JUnderlinedPanel object
    *
    * @return   The lineInsets value
    */
   public Insets getLineInsets()
   {
      return lineInsets;
   }


   /**
    * Sets the lineInsets attribute of the JUnderlinedPanel object
    *
    * @param insets  The new lineInsets value
    */
   public void setLineInsets (Insets insets)
   {
      if (lineInsets != insets)
      {
         lineInsets = insets;
      } // end of if ()
   }


   /**
    * Sets the font attribute of the JUnderlinedPanel object
    *
    * @param theFont  The new font value
    */
   public void setFont (Font theFont)
   {
      int index = 0;
      Component[] components = null;

      super.setFont (theFont);
      components = getComponents();
      while (index < components.length)
      {
         components[index].setFont (theFont);
         index++;
      }
   }


   /**
    * Overwrites the paint method of the JScrollPane.
    *
    * @param g  No description provided
    */
   public void paint (Graphics g)
   {
      super.paint (g);

      if (isUnderlined())
      {
         Rectangle bounds = getBounds();

         int x = 0;
         int y = bounds.height - 1;
         int width = bounds.width;
         int height = bounds.height - 1;

         Insets insets = getLineInsets();
         if (getLineInsets() != null)
         {
            x = insets.left;
            y = bounds.height - insets.bottom;
            width = bounds.width - insets.left - insets.right;
            height = bounds.height - insets.bottom;
         } // end of if ()

         if (getLayout() != null)
         {
            Dimension dim = getLayout().preferredLayoutSize (this);

            width = dim.width;
         }

         g.drawLine (x, y, width, height);
      } // end of if ()

   }
}

/*
 * $Log: JUnderlinedPanel.java,v $
 * Revision 1.15  2004/11/03 10:17:58  lowende
 * Javadoc warnings removed.
 *
 */
