/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;


/**
 * This class is a swing component which draws Stickmen. With arms up of course.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.13 $
 */
public class JStickMan extends JComponent
{
   /**
    * Sets the height attribute of the JStickMan object
    *
    * @param height  The new height value
    */
   public void setHeight (int height)
   {
      this.setSize (width (height), height);
   }


   /**
    * Default constructor.
    */
   public JStickMan()
   {
      super();
      setHeight (50);
   }


   /**
    * Construct a new JStickMan with given height.
    *
    * @param height  height in points
    */
   public JStickMan (int height)
   {
      super();
      setHeight (50);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param height  No description provided
    * @return        No description provided
    */
   private int width (int height)
   {
      return 2 * height / 3;
   }


   /**
    * Get the preferredSize attribute of the JStickMan object
    *
    * @return   The preferredSize value
    */
   public Dimension getPreferredSize()
   {
      return new Dimension (width (getHeight()), getHeight());
   }


   /**
    * This method is called by paint to actually draw the stickman.
    *
    * @param g  No description provided
    */
   protected void paintComponent (Graphics g)
   {
      Color oldColor = g.getColor();

      g.setColor (getForeground());

      // proportions
      int height = getHeight();
      int width = width (height);
      int head_diameter = height / 3;
      int legs_height = 3 * height / 10;
      int legs_width = 2 * width / 5;
      int arms_height = height / 6;
      int arms_width = width / 2;
      int body_height = height - head_diameter - legs_height;

      // positions
      int x_middle = getWidth() / 2;
      int head_x = x_middle - head_diameter / 2;
      int head_y = 0;

      int body_x = x_middle;
      int body_y1 = head_y + head_diameter;
      int body_y2 = body_y1 + body_height;

      int lleg_x1 = body_x;
      int lleg_y1 = body_y2;
      int lleg_x2 = body_x - legs_width;
      int lleg_y2 = lleg_y1 + legs_height;

      int rleg_x1 = body_x;
      int rleg_y1 = body_y2;
      int rleg_x2 = body_x + legs_width;
      int rleg_y2 = rleg_y1 + legs_height;

      int larm_x1 = body_x;
      int larm_y1 = body_y1 + body_height / 3;
      int larm_x2 = larm_x1 - arms_width;
      int larm_y2 = larm_y1 - arms_height;

      int rarm_x1 = body_x;
      int rarm_y1 = body_y1 + body_height / 3;
      int rarm_x2 = rarm_x1 + arms_width;
      int rarm_y2 = rarm_y1 - arms_height;

      g.drawOval (head_x, head_y, head_diameter, head_diameter);
      g.drawLine (body_x, body_y1, body_x, body_y2);
      g.drawLine (lleg_x1, lleg_y1, lleg_x2, lleg_y2);
      g.drawLine (rleg_x1, rleg_y1, rleg_x2, rleg_y2);
      g.drawLine (larm_x1, larm_y1, larm_x2, larm_y2);
      g.drawLine (rarm_x1, rarm_y1, rarm_x2, rarm_y2);

      g.setColor (oldColor);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void reshape (int x, int y, int width, int height)
   {
      Rectangle bounds = getBounds();
      if (x != bounds.x || y != bounds.y
         || width != bounds.width || height != bounds.height)
      {
         super.reshape (x, y, width, height);
         if (x != bounds.x || y != bounds.y)
         {
            firePropertyChange ("location", bounds.getLocation(),
               new Point (x, y));
         }

         if (width != bounds.width || height != bounds.height)
         {
            firePropertyChange ("size", bounds.getSize(),
               new Dimension (width, height));
         }

         firePropertyChange ("bounds", bounds,
            new Rectangle (x, y, width, height));
      }
   }
}

/*
 * $Log: JStickMan.java,v $
 * Revision 1.13  2004/11/03 10:17:58  lowende
 * Javadoc warnings removed.
 *
 */
