/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;
import java.awt.geom.GeneralPath;
import java.util.Iterator;


/**
 * Simple arrow with single line
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.3 $
 */
public class JSimpleArrowHead extends JArrowHead
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int DEFAULT_WIDTH = 11;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int DEFAULT_HEIGHT = 16;


   /**
    * Constructor for class JSimpleArrowHead
    */
   public JSimpleArrowHead()
   {
      this (DEFAULT_HEIGHT);
   }


   /**
    * Constructor for class JSimpleArrowHead
    *
    * @param size  The size of the arrow head
    */
   public JSimpleArrowHead (int size)
   {
      this (size * DEFAULT_WIDTH / DEFAULT_HEIGHT, size);
   }


   /**
    * Constructor for class JSimpleArrowHead
    *
    * @param width   No description provided
    * @param height  No description provided
    */
   public JSimpleArrowHead (int width, int height)
   {
      // Register size, shape not filled
      // @todo Size and PreferredSize should be transformed, not guessed
      setSize (width, height);
      setPreferredSize (new Dimension (height, height));
      setFilled (false);

      /*
       *  Draw the cap
       */
      GeneralPath shape = new GeneralPath();
      shape.moveTo ( (height - width) / 2, height - 1);
      shape.lineTo ( (height - 1) / 2, 0);
      shape.lineTo ( (height + width - 2) / 2, height - 1);

      /*
       *  Draw the beginning of the line
       */
      shape.moveTo ( (height - 1) / 2, 0);
      shape.lineTo ( (height - 1) / 2, height - 1);

      getShapeList().add (shape);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param g  No description provided
    */
   public void paintArrow (Graphics g)
   {
      Color oldColor = g.getColor();

      g.setColor (getForeground());

      Iterator iter = getShapeList().iterator();
      while (iter.hasNext())
      {
         GeneralPath shape = (GeneralPath) iter.next();
         Graphics2D g2d = (Graphics2D) g;
         g2d.draw (at.createTransformedShape (shape));
      }
      g.setColor (oldColor);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Object clone()
   {
      return new JSimpleArrowHead (getWidth(), getHeight());
   }

}

/*
 * $Log: JSimpleArrowHead.java,v $
 * Revision 1.3  2004/10/20 17:49:46  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
