/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import de.uni_paderborn.fujaba.layout.options.LayoutPreferences;


/**
 * Defines a JPanel with delimiters.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.15 $
 */
public class JSeparatedPanel extends JBoundsPanel
{
   /**
    * overrides the standard constructor of JPanel. This constructor sets a ColumnRowLayout
    * as default layouter.
    */
   public JSeparatedPanel()
   {
      super();
      setLayout (SeparatedPanelLayout.get());
   }


   /**
    * holds the last separator of the panel. This attribute is needed during constructing the
    * panel.
    */
   private JExtendedSeparator lastSeparator = null;


   /**
    * insert a separator at the and of the component list.
    */
   public void addSeparator()
   {
      Component comp = getComponent (getComponentCount() - 1);

      JExtendedSeparator sep = new JExtendedSeparator();
      lastSeparator = sep;

      sep.setUI (new UMLSeparatorUI());
      lastSeparator.setFirst (comp);
      super.add (sep);
   }


   /**
    * Get the lastSeparator attribute of the JSeparatedPanel object
    *
    * @return   The lastSeparator value
    */
   public JExtendedSeparator getLastSeparator()
   {
      return this.lastSeparator;
   }


   /**
    * overrides the Container method add.
    *
    * @param comp  No description provided
    * @return      No description provided
    */
   public Component add (Component comp)
   {
      if (lastSeparator != null &&
         lastSeparator.getSecond() == null)
      {
         lastSeparator.setSecond (comp);
      } // end of if ()
      return super.add (comp);
   }


   /**
    * overrides the Container method add.
    *
    * @param name  No description provided
    * @param comp  No description provided
    * @return      No description provided
    */
   public Component add (String name, Component comp)
   {
      if (lastSeparator != null &&
         lastSeparator.getSecond() == null)
      {
         lastSeparator.setSecond (comp);
      } // end of if ()
      return super.add (name, comp);
   }


   /**
    * overrides the method getPreferredSize() of Component.
    *
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   /*
    *  public Dimension getPreferredSize()
    *  {
    *  SeparatedPanelLayout layout = (SeparatedPanelLayout) getLayout();
    *  return layout.preferredLayoutSize (this);
    *  }
    */
   /**
    * overrides the method getMaximumSize() of Component.
    *
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   /*
    *  public Dimension getMaximumSize()
    *  {
    *  SeparatedPanelLayout layout = (SeparatedPanelLayout) getLayout();
    *  return layout.maximumLayoutSize (this);
    *  }
    */
   /**
    * overrides the method getMaximumSize() of Component.
    *
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   /*
    *  public Dimension getMinimumSize()
    *  {
    *  SeparatedPanelLayout layout = (SeparatedPanelLayout) getLayout();
    *  return layout.minimumLayoutSize (this);
    *  }
    */
   /**
    * overrides the method reshape (int x, int y, int width, int height) of JBoundsPanel.
    *
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void reshape (int x, int y, int width, int height)
   {
      // Get Options before start
      LayoutPreferences options = LayoutPreferences.get();
      int minWidth = options.getMinimumWidth();

      if (width < minWidth)
      {
         width = minWidth;
      }

      super.reshape (x, y, width, height);
   }
}

/*
 * $Log: JSeparatedPanel.java,v $
 * Revision 1.15  2004/11/03 10:17:58  lowende
 * Javadoc warnings removed.
 *
 */
