/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;


/**
 * just a small rhomb
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public class JRhomb extends JComponent
{
   /**
    * Constructor for class JRhomb
    */
   public JRhomb()
   {
      this (true);
   }


   /**
    * Constructor for class JRhomb
    *
    * @param filled  No description provided
    */
   public JRhomb (boolean filled)
   {
      this (17, filled);
   }


   /**
    * Constructor for class JRhomb
    *
    * @param size    No description provided
    * @param filled  No description provided
    */
   public JRhomb (int size, boolean filled)
   {
      super();
      setFilled (filled);
      Dimension dim = new Dimension (size, size);
      setSize (dim);
      setPreferredSize (dim);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean filled = false;


   /**
    * Sets the filled attribute of the JRhomb object
    *
    * @param filled  The new filled value
    */
   public void setFilled (boolean filled)
   {
      if (this.filled != filled)
      {
         this.filled = filled;

         firePropertyChange ("filled", !filled, filled);
      }
   }


   /**
    * Get the filled attribute of the JRhomb object
    *
    * @return   The filled value
    */
   public boolean isFilled()
   {
      return this.filled;
   }


   /**
    * @param g  Graphics
    */
   public void paintComponent (Graphics g)
   {
      Color oldColor = g.getColor();
      Rectangle bounds = getBounds();

      // fill rectangle (0,0,radius*2,radius*2) with color
      g.setColor (getForeground());

      int newX[] = new int[5];
      int newY[] = new int[5];

      newX[0] = 0;
      newX[1] =  (bounds.width - 1) / 2;
      newX[2] = bounds.width - 1;
      newX[3] =  (bounds.width - 1) / 2;
      newX[4] = 0;

      newY[0] =  (bounds.height - 1) / 2;
      newY[1] = 0;
      newY[2] =  (bounds.height - 1) / 2;
      newY[3] = bounds.height - 1;
      newY[4] =  (bounds.height - 1) / 2;

      if (!isFilled())
      {
         g.setColor (getBackground());
         g.fillPolygon (newX, newY, 5);
         g.setColor (getForeground());
         g.drawPolyline (newX, newY, 5);
      }
      else
      {
         g.setColor (getForeground());
         g.fillPolygon (newX, newY, 5);
      }
      g.setColor (oldColor);
   }
}

/*
 * $Log: JRhomb.java,v $
 * Revision 1.11  2004/11/03 10:17:58  lowende
 * Javadoc warnings removed.
 *
 */
