/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;


/**
 * This class is a swing component which draws ovals in wonderful shapes.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.13 $
 */
public class JOval extends JComponent
{
   /**
    * Default constructor.
    */
   public JOval()
   {
      super();
   }


   /**
    * Call this constructor to create a new JOval with given diameters.
    *
    * @param width   the oval's width in points
    * @param height  the oval's height in points
    */
   public JOval (int width, int height)
   {
      super();
      setSize (width, height);
   }


   /**
    * Get the preferredSize attribute of the JOval object
    *
    * @return   The preferredSize value
    */
   public Dimension getPreferredSize()
   {
      return new Dimension (getWidth(), getHeight());
   }


   /**
    * This method is called by paint to actually draw the circle.
    *
    * @param g  No description provided
    */
   protected void paintComponent (Graphics g)
   {
      Color oldColor = g.getColor();
      g.setColor (getForeground());
      g.drawOval (0, 0, getWidth(), getHeight());
      g.setColor (oldColor);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void reshape (int x, int y, int width, int height)
   {
      Rectangle bounds = getBounds();
      if (x != bounds.x || y != bounds.y
         || width != bounds.width || height != bounds.height)
      {
         super.reshape (x, y, width, height);
         if (x != bounds.x || y != bounds.y)
         {
            firePropertyChange ("location", bounds.getLocation(),
               new Point (x, y));
         }

         if (width != bounds.width || height != bounds.height)
         {
            firePropertyChange ("size", bounds.getSize(),
               new Dimension (width, height));
         }

         firePropertyChange ("bounds", bounds,
            new Rectangle (x, y, width, height));
      }
   }
}

/*
 * $Log: JOval.java,v $
 * Revision 1.13  2004/11/03 10:17:57  lowende
 * Javadoc warnings removed.
 *
 */
