/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;


/**
 * This class is a swing component which draws circles in wonderful shapes.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.15 $
 */
public class JCircle extends JComponent
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int radius = 0;


   /**
    * Get the radius attribute of the JCircle object
    *
    * @return   The radius value
    */
   public int getRadius()
   {
      return radius;
   }


   /**
    * Sets the radius attribute of the JCircle object
    *
    * @param radius  The new radius value
    */
   public void setRadius (int radius)
   {
      this.radius = radius;
   }


   /**
    * the inset of the radius.
    */
   private int radiusInset = 0;


   /**
    * get the value of radiusInset.
    *
    * @return   the value of radiusInset
    */
   public int getRadiusInset()
   {
      return this.radiusInset;
   } // getRadiusInset


   /**
    * set the value of radiusInset.
    *
    * @param value  The new radiusInset value
    */
   public void setRadiusInset (int value)
   {
      if (this.radiusInset != value)
      {
         this.radiusInset = value;
      } // if ()
   } // setRadiusInset


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean filled = false;


   /**
    * Sets the filled attribute of the JCircle object
    *
    * @param filled  The new filled value
    */
   public void setFilled (boolean filled)
   {
      if (this.filled != filled)
      {
         boolean oldfilled = this.filled;
         this.filled = filled;
         firePropertyChange ("filled", oldfilled, filled);
      }
   }


   /**
    * Get the filled attribute of the JCircle object
    *
    * @return   The filled value
    */
   public boolean getFilled()
   {
      return filled;
   }


   /**
    * Default constructor.
    */
   public JCircle()
   {
      super();
      setOpaque (false);
   }


   /**
    * Call this constructor to create a new JCircle with a radius.
    *
    * @param radius  the radius in points
    */
   public JCircle (int radius)
   {
      super();
      this.radius = radius;
   }


   /**
    * Get the preferredSize attribute of the JCircle object
    *
    * @return   The preferredSize value
    */
   public Dimension getPreferredSize()
   {
      return new Dimension ( (radius + radiusInset) * 2 + 1,  (radius + radiusInset) * 2 + 1);
   }


   /**
    * This method is called by paint to actually draw the circle.
    *
    * @param g  No description provided
    */
   protected void paintComponent (Graphics g)
   {
      Color oldColor = g.getColor();
      g.setColor (getForeground());

      if (radiusInset > 0)
      {
         g.drawOval (0, 0,  (radius + radiusInset) * 2,  (radius + radiusInset) * 2);
      } // end of if ()

      if (filled == true)
      {
         g.fillOval (radiusInset, radiusInset, radius * 2, radius * 2);
      }
      else
      {
         g.drawOval (radiusInset, radiusInset, radius * 2, radius * 2);
      }

      g.setColor (oldColor);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void reshape (int x, int y, int width, int height)
   {
      Rectangle bounds = getBounds();
      if (x != bounds.x || y != bounds.y || width != bounds.width || height != bounds.height)
      {
         super.reshape (x, y, width, height);
         if (x != bounds.x || y != bounds.y)
         {
            firePropertyChange ("location", bounds.getLocation(), new Point (x, y));
         }

         if (width != bounds.width || height != bounds.height)
         {
            firePropertyChange ("size", bounds.getSize(), new Dimension (width, height));
         }

         firePropertyChange ("bounds", bounds, new Rectangle (x, y, width, height));
      }
   }
}

/*
 * $Log: JCircle.java,v $
 * Revision 1.15  2004/11/03 10:17:57  lowende
 * Javadoc warnings removed.
 *
 */
