/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.*;


/**
 * This class is a swing component which draws arrows.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.2 $
 */

public class JBigArrow extends JTriangleHeadWithTail implements PropertyChangeListener
{

   /**
    * Arrow points from source to target.
    */
   private JComponent source = null;
   /**
    * Arrow points from source to target.
    */
   private JComponent target = null;


   /**
    * Default constructor.
    */
   public JBigArrow()
   {
      super (13, 26, true);
   }


   /**
    * Get the doubleArrow attribute of the JArrow object
    *
    * @return   The doubleArrow value
    */
   public boolean isDoubleArrow()
   {
      return doubleArrow;
   }


   /**
    * Sets the doubleArrow attribute of the JArrow object
    *
    * @param doubleArrow  The new doubleArrow value
    */
   public void setDoubleArrow (boolean doubleArrow)
   {
      this.doubleArrow = doubleArrow;
      propertyChange (null);
   }


   /**
    * Call this constructor to create a new JArrow pointing to the target Component. Please
    * use only such JComponents which fire "bounds"-propertychanges.
    *
    * @param target  target for the arrow.
    * @param source  No description provided
    */
   public JBigArrow (JComponent target, JComponent source)
   {
      this();
      setTarget (target);
      setSource (source);
   }


   /**
    * Sets the target attribute of the JArrow object
    *
    * @param target  The new target value
    */
   public void setTarget (JComponent target)
   {
      if (this.target != target)
      {
         if (this.target != null)
         {
            this.target.removePropertyChangeListener ("bounds", this);
         }
         this.target = target;
         if (target != null)
         {
            target.addPropertyChangeListener ("bounds", this);
            propertyChange (null);
         }
      }
   }


   /**
    * Sets the source attribute of the JArrow object
    *
    * @param source  The new source value
    */
   public void setSource (JComponent source)
   {
      if (this.source != source)
      {
         if (this.source != null)
         {
            this.source.removePropertyChangeListener ("bounds", this);
         }
         this.source = source;
         if (source != null)
         {
            source.addPropertyChangeListener ("bounds", this);
            propertyChange (null);
         }
      }
   }


   /**
    * Get the target attribute of the JArrow object
    *
    * @return   The target value
    */
   public JComponent getTarget()
   {
      return target;
   }


   /**
    * Get the source attribute of the JArrow object
    *
    * @return   The source value
    */
   public JComponent getSource()
   {
      return source;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void propertyChange (PropertyChangeEvent e)
   {
      if ( (target == null) ||  (source == null))
      {
         return;
      }

      int targetX = target.getX();
      int targetY = target.getY();
      int width = target.getWidth();
      int height = target.getHeight();
      float m = 0.5f;
      if (width != 0)
      {
         m = (float) height / (float) width;
      }
      int b1 = targetY - (int)  (m * targetX);
      int b2 = targetY + (int)  (m *  (targetX + width));

      int parentX = source.getX() + source.getWidth() / 2;
      int parentY = source.getY() + source.getHeight() / 2;

      int line1Y = (int)  (m * parentX + b1);
      int line2Y = (int)  (-m * parentX + b2);

      if (parentY > line1Y)
      {
         // left or right
         if (parentY > line2Y)
         {
            // right
            setDirection (Direction.TOP);
         }
         else
         {
            // left
            setDirection (Direction.RIGHT);
         }
      }
      else
      {
         // up or down
         if (parentY < line2Y)
         {
            // down
            setDirection (Direction.BOTTOM);
         }
         else
         {
            // up
            setDirection (Direction.LEFT);
         }
      }

      revalidate();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void reshape (int x, int y, int width, int height)
   {
      Rectangle bounds = getBounds();
      if (x != bounds.x || y != bounds.y || width != bounds.width || height != bounds.height)
      {
         super.reshape (x, y, width, height);
         if (x != bounds.x || y != bounds.y)
         {
            firePropertyChange ("location", bounds.getLocation(), new Point (x, y));
         }

         if (width != bounds.width || height != bounds.height)
         {
            firePropertyChange ("size", bounds.getSize(), new Dimension (width, height));
         }

         firePropertyChange ("bounds", bounds, new Rectangle (x, y, width, height));
      }
   }

}

/*
 * $Log: JBigArrow.java,v $
 * Revision 1.2  2004/10/20 17:49:48  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
