/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.*;

import org.apache.log4j.Logger;

import de.uni_paderborn.lib.basic.ImageResourceManager;
import de.uni_paderborn.lib.classloader.UPBClassLoader;


/**
 * This class is a swing component which draws arrows.
 *
 * @author       $Author: mksoft $
 * @version      $Revision: 1.19.2.2 $
 * @deprecated   Use JDirectionIndicator
 */

public class JArrow extends JLabel implements PropertyChangeListener
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (JArrow.class);

   /**
    * Arrow points from source to target.
    */
   private JComponent source = null;
   /**
    * Arrow points from source to target.
    */
   private JComponent target = null;

   /**
    * Arrow pointing up.
    *
    * @deprecated   Use Direction.TOP
    */
   private final static int UP = 0;
   /**
    * Arrow pointing up.
    *
    * @deprecated   Use Direction.RIGHT
    */
   private final static int RIGHT = 1;
   /**
    * Arrow pointing up.
    *
    * @deprecated   Use Direction.BOTTOM
    */
   private final static int DOWN = 2;
   /**
    * Arrow pointing up.
    *
    * @deprecated   Use Direction.LEFT
    */
   private final static int LEFT = 3;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean textMode = false;


   /**
    * Get the textMode attribute of the JArrow object
    *
    * @return   The textMode value
    */
   public boolean isTextMode()
   {
      return textMode;
   }


   /**
    * Sets the textMode attribute of the JArrow object
    *
    * @param textMode  The new textMode value
    */
   public void setTextMode (boolean textMode)
   {
      this.textMode = textMode;
      propertyChange (null);
   }


   /**
    * Double Arrow is used for collaborations on sets.
    */
   private boolean doubleArrow = false;


   /**
    * Get the doubleArrow attribute of the JArrow object
    *
    * @return   The doubleArrow value
    */
   public boolean isDoubleArrow()
   {
      if (log.isInfoEnabled())
      {
         log.info ("FSAArrow.isDoubleArrow");
      }
      return doubleArrow;
   }


   /**
    * Sets the doubleArrow attribute of the JArrow object
    *
    * @param doubleArrow  The new doubleArrow value
    */
   public void setDoubleArrow (boolean doubleArrow)
   {
      if (log.isInfoEnabled())
      {
         log.info ("FSAArrow.setDoubleArrow");
      }
      this.doubleArrow = doubleArrow;
      propertyChange (null);
   }


   /**
    * Big Arrow is used for collaborations messages.
    */
   private boolean bigArrow = false;


   /**
    * Get the bigArrow attribute of the JArrow object
    *
    * @return   The bigArrow value
    */
   public boolean isBigArrow()
   {
      return bigArrow;
   }


   /**
    * Sets the bigArrow attribute of the JArrow object
    *
    * @param bigArrow  The new bigArrow value
    */
   public void setBigArrow (boolean bigArrow)
   {
      this.bigArrow = bigArrow;
      propertyChange (null);
   }


   /**
    * Default constructor.
    */
   public JArrow()
   {
      super();
   }


   /**
    * Call this constructor to create a new JArrow pointing to the target Component. Please
    * use only such JComponents which fire "bounds"-propertychanges.
    *
    * @param target  target for the arrow.
    * @param source  No description provided
    */
   public JArrow (JComponent target, JComponent source)
   {
      this();
      setTarget (target);
      setSource (source);
   }


   /**
    * Sets the target attribute of the JArrow object
    *
    * @param target  The new target value
    */
   public void setTarget (JComponent target)
   {
      if (this.target != target)
      {
         if (this.target != null)
         {
            this.target.removePropertyChangeListener ("bounds", this);
         }
         this.target = target;
         if (target != null)
         {
            target.addPropertyChangeListener ("bounds", this);
            propertyChange (null);
         }
      }
   }


   /**
    * Sets the source attribute of the JArrow object
    *
    * @param source  The new source value
    */
   public void setSource (JComponent source)
   {
      if (this.source != source)
      {
         if (this.source != null)
         {
            this.source.removePropertyChangeListener ("bounds", this);
         }
         this.source = source;
         if (source != null)
         {
            source.addPropertyChangeListener ("bounds", this);
            propertyChange (null);
         }
      }
   }


   /**
    * Get the target attribute of the JArrow object
    *
    * @return   The target value
    */
   public JComponent getTarget()
   {
      return target;
   }


   /**
    * Get the source attribute of the JArrow object
    *
    * @return   The source value
    */
   public JComponent getSource()
   {
      return source;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void propertyChange (PropertyChangeEvent e)
   {
      if ( (target == null) ||  (source == null))
      {
         return;
      }

      int targetX = target.getX();
      int targetY = target.getY();
      int width = target.getWidth();
      int height = target.getHeight();
      float m = 0.5f;
      if (width != 0)
      {
         m = (float) height / (float) width;
      }
      int b1 = targetY - (int)  (m * targetX);
      int b2 = targetY + (int)  (m *  (targetX + width));

      int parentX = source.getX() + source.getWidth() / 2;
      int parentY = source.getY() + source.getHeight() / 2;

      int line1Y = (int)  (m * parentX + b1);
      int line2Y = (int)  (-m * parentX + b2);
      int newDirection;

      if (parentY > line1Y)
      {
         // left or right
         if (parentY > line2Y)
         {
            // right
            newDirection = UP;
         }
         else
         {
            // left
            newDirection = RIGHT;
         }
      }
      else
      {
         // up or down
         if (parentY < line2Y)
         {
            // down
            newDirection = DOWN;
         }
         else
         {
            // up
            newDirection = LEFT;
         }
      }

//If doubleArrow has changed, arrow must be redrawn, so we can not longer check for
// if (newDirection != direction) here
      if (doubleArrow)
      {
         if (!textMode)
         {
            setText (null);
            ImageResourceManager manager = ImageResourceManager.get();

            switch (newDirection)
            {
               case UP:
                  setIcon (manager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/arrowupOnEach.gif"));
                  break;
               case RIGHT:
                  setIcon (manager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/arrowrightOnEach.gif"));
                  break;
               case DOWN:
                  setIcon (manager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/arrowdownOnEach.gif"));
                  break;
               case LEFT:
                  setIcon (manager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/arrowleftOnEach.gif"));
                  break;
               default:
                  throw new RuntimeException ("Only arrow indices beetween 0 and 3 are allowed.");
            }
         }
         else
         {
            setIcon (null);
            switch (newDirection)
            {
               case UP:
                  setText ("^^");
                  break;
               case RIGHT:
                  setText (">>");
                  break;
               case DOWN:
                  setText ("vv");
                  break;
               case LEFT:
                  setText ("<<");
                  break;
               default:
                  throw new RuntimeException ("Only arrow indices beetween 0 and 3 are allowed.");
            }
         }
      }
      else
      {
         if (!textMode)
         {
            setText (null);
            ImageResourceManager manager = ImageResourceManager.get();
            if (!isBigArrow())
            {
               switch (newDirection)
               {
                  case UP:
                     setIcon (manager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/smallarrowup.gif"));
                     break;
                  case RIGHT:
                     setIcon (manager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/smallarrowright.gif"));
                     break;
                  case DOWN:
                     setIcon (manager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/smallarrowdown.gif"));
                     break;
                  case LEFT:
                     setIcon (manager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/smallarrowleft.gif"));
                     break;
                  default:
                     throw new RuntimeException ("Only arrow indices beetween 0 and 3 are allowed.");
               }
            }
            else
            {
               switch (newDirection)
               {
                  case UP:
                     setIcon (manager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/arrowup.gif"));
                     break;
                  case RIGHT:
                     setIcon (manager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/arrowright.gif"));
                     break;
                  case DOWN:
                     setIcon (manager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/arrowdown.gif"));
                     break;
                  case LEFT:
                     setIcon (manager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/arrowleft.gif"));
                     break;
                  default:
                     throw new RuntimeException ("Only arrow indices beetween 0 and 3 are allowed.");
               }
            }
         }
         else
         {
            setIcon (null);
            switch (newDirection)
            {
               case UP:
                  setText ("^");
                  break;
               case RIGHT:
                  setText (">");
                  break;
               case DOWN:
                  setText ("v");
                  break;
               case LEFT:
                  setText ("<");
                  break;
               default:
                  throw new RuntimeException ("Only arrow indices beetween 0 and 3 are allowed.");
            }
         }
      }

      revalidate();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param x       No description provided
    * @param y       No description provided
    * @param width   No description provided
    * @param height  No description provided
    */
   public void reshape (int x, int y, int width, int height)
   {
      Rectangle bounds = getBounds();
      if (x != bounds.x || y != bounds.y || width != bounds.width || height != bounds.height)
      {
         super.reshape (x, y, width, height);
         if (x != bounds.x || y != bounds.y)
         {
            firePropertyChange ("location", bounds.getLocation(), new Point (x, y));
         }

         if (width != bounds.width || height != bounds.height)
         {
            firePropertyChange ("size", bounds.getSize(), new Dimension (width, height));
         }

         firePropertyChange ("bounds", bounds, new Rectangle (x, y, width, height));
      }
   }

}

/*
 * $Log: JArrow.java,v $
 * Revision 1.19.2.2  2005/09/30 18:57:07  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
