/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.util.Comparator;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.metamodel.FIncrement;
import de.uni_paderborn.fujaba.uml.UMLIncrement;


/**
 * $Id: IncrementComparator.java,v 1.9 2004/11/03 10:17:57 lowende Exp $
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.9 $
 */
public class IncrementComparator implements Comparator
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static transient IncrementComparator singleton = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static IncrementComparator get()
   {
      if (singleton == null)
      {
         singleton = new IncrementComparator();
      }
      return singleton;
   }


   /**
    * Constructor for class IncrementComparator
    */
   protected IncrementComparator() { }


   /**
    * Get the comparisonString attribute of the IncrementComparator object
    *
    * @param incr  No description provided
    * @return      The comparisonString value
    */
   protected String getComparisonString (UMLIncrement incr)
   {
      return  (incr == null ? null : incr.getName());
   }


   /**
    * Get the increment attribute of the IncrementComparator object
    *
    * @param o  No description provided
    * @return   The increment value
    */
   private UMLIncrement getIncrement (Object o)
   {
      UMLIncrement result = null;
      if (o != null)
      {
         if (o instanceof JComponent)
         {
            FSAObject fsa = FSAObject.getFSAObjectFromJComponent ((JComponent) o);
            if (fsa != null)
            {
               result = (UMLIncrement) fsa.getLogic();
            }
         }
         else if (o instanceof FSAObject)
         {
            result = (UMLIncrement)  ((FSAObject) o).getLogic();
         }
         else if (o instanceof FIncrement)
         {
            result = (UMLIncrement) o;
         }
      }
      return result;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param o1  No description provided
    * @param o2  No description provided
    * @return    No description provided
    */
   public int compare (Object o1, Object o2)
   {
      UMLIncrement incr1 = getIncrement (o1);
      UMLIncrement incr2 = getIncrement (o2);

      String s1 = getComparisonString (incr1);
      String s2 = getComparisonString (incr2);

      if (s1 == null)
      {
         if (s2 != null)
         {
            return -1;
         }
         else
         {
            return 0;
         }
      }
      else
      {
         if (s2 == null)
         {
            return 1;
         }
         else
         {
            return s1.compareTo (s2);
         }
      }
   }
}

/*
 * $Log: IncrementComparator.java,v $
 * Revision 1.9  2004/11/03 10:17:57  lowende
 * Javadoc warnings removed.
 *
 */
