/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;


/**
 * Constraints for main component in PanelGrabUI</p> Warning: does not work correctly yet
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 * @see       PanelGrabUI
 */
public class GrabConstraints implements DecoratorLayout.Constraints
{
   /**
    * Constructor for class GrabConstraints
    *
    * @param target  No description provided
    */
   public GrabConstraints (JGrab target)
   {
      setTarget (target);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Component target = null;


   /**
    * UMLMethod: 'Read access method for attribute target : Component'
    *
    * @return   The target value
    */
   public Component getTarget()
   {
      return target;
   }


   /**
    * UMLMethod: 'Write access method for attribute target : Component'
    *
    * @param target  The new target value
    * @return        No description provided
    */
   public Component setTarget (Component target)
   {
      if (this.target != target)
      {
         if (! (target instanceof JGrab))
         {
            throw new IllegalArgumentException ("Target must be a JGrab");
         }

         this.target = target;
      } // if

      return this.target;
   }


   /**
    * Get the location attribute of the GrabConstraints object
    *
    * @param comp  No description provided
    * @return      The location value
    */
   public Point getLocation (Component comp)
   {
      JGrab grab = (JGrab) getTarget();

      if (grab == null)
      {
         return comp.getLocation();
      }

      Point pos = grab.getLocation();
      pos = SwingUtilities.convertPoint (grab.getParent(), pos, comp.getParent());

      Dimension grabDim = grab.getSize();
      Dimension compDim = comp.getPreferredSize();

      if (grab.getOrientation() == Direction.TOP || grab.getOrientation() == Direction.BOTTOM)
      {
         pos.y +=  ( (grab.getOrientation() == Direction.TOP) ? 1 : -1) *  (grabDim.height - compDim.height);
         pos.x +=  (grabDim.width - compDim.width) / 2;
      }
      else
      {
         pos.x +=  ( (grab.getOrientation() == Direction.LEFT) ? 1 : -1) *  (grabDim.width - compDim.width);
         pos.y +=  (grabDim.height - compDim.height) / 2;
      }
      return pos;
   }


   /**
    * UMLMethod: '+ removeYou () : Void'
    */
   public void removeYou()
   {
      setTarget (null);
   }
}

/*
 * $Log: GrabConstraints.java,v $
 * Revision 1.10  2004/10/20 17:49:45  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
