/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.listener.AscendDescendMouseHandler;
import de.upb.tools.fca.FTreeMap;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.10 $
 */
public class EditorManager
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int LAYER = JLayeredPane.DRAG_LAYER.intValue() + 1000;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String LAYER_NAME = "EditorComponentLayer";

   static
   {
      LayerManager.get().addToLayerPositions (LAYER_NAME, new Integer (LAYER));
   }

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static EditorManager manager = null;


   /**
    * Constructor for class EditorManager
    */
   private EditorManager() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static EditorManager get()
   {
      if (manager == null)
      {
         manager = new EditorManager();
      } // end of if ()
      return manager;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FTreeMap editors = null;


   /**
    * Get the editor attribute of the EditorManager object
    *
    * @param key        No description provided
    * @param className  No description provided
    * @return           The editor value
    */
   public JComponent getEditor (String key, String className)
   {
      JComponent object = null;
      if (editors == null)
      {
         editors = new FTreeMap();
      } // end of if ()

      if (key != null &&
         !editors.containsKey (key))
      {
         try
         {
            //UPBClassLoader loader = UPBClassLoader.get();
            object = (JComponent) Class.forName (className
            /*
             *  , true, loader
             */
               ).newInstance();
            editors.put (key, object);

            // handle the already registered listeners by AscendDescendMouseHandler too
            // but does not work with all editors, so commented out for the moment...
            //AscendDescendMouseHandler.claimMouseListeners (object);
            //AscendDescendMouseHandler.claimMouseMotionListeners (object);
            // register handler for event propagation instead
            AscendDescendMouseHandler.registerADMouseInputHandler (object);

            // No descending events beyond this component (if it is visible)
            AscendDescendMouseHandler.addMouseInputListener (object, AscendDescendMouseHandler.getDescendConsumer());

            LayerManager.setLayerType (object, LAYER_NAME); //for future placing of editors on glassPane
         }
         catch (Exception e)
         {
            e.printStackTrace();
            throw new RuntimeException ("Unable to load Editor class " + className + ", " + e.getClass().getName() + ": \"" + e.getMessage() + "\"");
         } // end of try-catch
      } // end of if ()
      else
      {
         object = (JComponent) editors.get (key);
      } // end of else
      return object;
   }

}

/*
 * $Log: EditorManager.java,v $
 * Revision 1.10  2004/11/03 10:17:56  lowende
 * Javadoc warnings removed.
 *
 */
