/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.lib.basic.ImageResourceManager;
import de.uni_paderborn.lib.classloader.UPBClassLoader;


/**
 * cell renderer for DiagramKindJComboBoxLabel
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.13.2.1 $
 */
public class DiagramKindListCellRenderer extends DefaultListCellRenderer
{

   /**
    * Get the listCellRendererComponent attribute of the DiagramKindListCellRenderer object
    *
    * @param list          No description provided
    * @param value         No description provided
    * @param index         No description provided
    * @param isSelected    No description provided
    * @param cellHasFocus  No description provided
    * @return              The listCellRendererComponent value
    */
   public Component getListCellRendererComponent (JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus)
   {
      setComponentOrientation (list.getComponentOrientation());

      if (isSelected)
      {
         setBackground (list.getSelectionBackground());
         setForeground (list.getSelectionForeground());
      }
      else
      {
         setBackground (list.getBackground());
         setForeground (list.getForeground());
      }

      int kindNo =  ((Integer) value).intValue();
      String iconPath = DiagramKindComboBoxModel.getIconPath (kindNo);

      ImageIcon tmpIcon = ImageResourceManager.get().getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, iconPath);

      setIcon (tmpIcon);
      setText (DiagramKindComboBoxModel.getName (kindNo));

      setEnabled (list.isEnabled());
      setFont (list.getFont());
      setBorder ( (cellHasFocus) ? UIManager.getBorder ("List.focusCellHighlightBorder") : noFocusBorder);

      return this;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "DiagramKindListCellRenderer";
   }

}

/*
 * $Log: DiagramKindListCellRenderer.java,v $
 * Revision 1.13.2.1  2005/07/11 09:04:35  cschneid
 * package diagrams support adding diagram kinds (for usecase diagrams), usages assoc pushed up to ASGDiagram, scrollbar hotfix for collabstat-editor
 *
 */
