/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import javax.swing.*;

import de.uni_paderborn.lib.basic.ImageResourceManager;
import de.uni_paderborn.lib.classloader.UPBClassLoader;


/**
 * edit instance of UMLAttr
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.17.2.1 $
 */
public class DiagramKindJComboBoxLabel
    extends AbstractJComboBoxLabel
{
   /**
    * Default Constructor
    */
   public DiagramKindJComboBoxLabel()
   {
      super();
      setModel (new DiagramKindComboBoxModel());
      setRenderer (new DiagramKindListCellRenderer());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void updateJLabel()
   {
      JComboBox comboBox = (JComboBox) EditorManager.get().
         getEditor (getClass().getName(), JComboBox.class.getName());
      Integer selectedItem = (Integer) comboBox.getSelectedItem();
      int tempIndex = selectedItem == null ? 0 : selectedItem.intValue();

      String iconPath = DiagramKindComboBoxModel.getIconPath (tempIndex);
      ImageIcon tmpIcon = ImageResourceManager.get().getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, iconPath);
      getLabel().setIcon (tmpIcon);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comboBox  No description provided
    */
   protected void updateJComboxBox (JComboBox comboBox)
   {
      comboBox.setSelectedItem (getValue());
   }

}

/*
 * $Log: DiagramKindJComboBoxLabel.java,v $
 * Revision 1.17.2.1  2005/07/11 09:04:34  cschneid
 * package diagrams support adding diagram kinds (for usecase diagrams), usages assoc pushed up to ASGDiagram, scrollbar hotfix for collabstat-editor
 *
 */
