/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;
import java.util.*;

import de.upb.tools.fca.FEmptyIterator;


/**
 * UMLClass: 'LineLayout'
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.12.2.1 $
 */
public class DelegationLayout implements LayoutManager2
{
   /**
    * UMLAttribute: 'layoutComponents : HashSet = null'
    */
   private HashMap layoutComponents = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInLayoutComponents (Component value)
   {
      return  ( (this.layoutComponents != null) &&
          (value != null) &&
         this.layoutComponents.containsValue (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfLayoutComponents()
   {
      return  ( (this.layoutComponents == null)
         ? FEmptyIterator.get()
         : this.layoutComponents.keySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator delegatesOfLayoutComponents()
   {
      return  ( (this.layoutComponents == null)
         ? FEmptyIterator.get()
         : this.layoutComponents.values().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator entriesOfLayoutComponents()
   {
      return  ( (this.layoutComponents == null)
         ? FEmptyIterator.get()
         : this.layoutComponents.entrySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfLayoutComponents()
   {
      return  ( (this.layoutComponents == null)
         ? 0
         : this.layoutComponents.size());
   }


   /**
    * Get the delegateeFromLayoutComponents attribute of the DelegationLayout object
    *
    * @param comp  No description provided
    * @return      The delegateeFromLayoutComponents value
    */
   public LayoutDelegatee getDelegateeFromLayoutComponents (Component comp)
   {
      return  ( ( (this.layoutComponents == null) ||  (comp == null))
         ? null
         : (LayoutDelegatee) this.layoutComponents.get (comp));
   }


   /**
    * Access method for an one to n association.
    *
    * @param value      The object added.
    * @param delegatee  The object added.
    */
   public void addToLayoutComponents (Component value, LayoutDelegatee delegatee)
   {
      addLayoutComponent (value, delegatee);
   }


   /**
    * Access method for an one to n association.
    *
    * @param entry  The object added.
    */
   public void addToLayoutComponents (Map.Entry entry)
   {
      addToLayoutComponents ((Component) entry.getKey(), (LayoutDelegatee) entry.getValue());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    */
   public void removeFromLayoutComponents (Component value)
   {
      removeLayoutComponent (value);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromLayoutComponents()
   {
      layoutComponents.clear();
   }


   /**
    * @param name   The object added.
    * @param comp   The object added.
    * @deprecated   replaced by <code>addLayoutComponent(Component, Object)</code>.
    */
   public void addLayoutComponent (String name, Component comp)
   {
      addLayoutComponent (comp, null);
   }


   /**
    * UMLMethod: '+ addLayoutComponent (comp : Component;delegatee : Object) : Void'
    *
    * @param comp       The object added.
    * @param delegatee  The object added.
    */
   public void addLayoutComponent (Component comp, Object delegatee)
   {
      if (comp != null)
      {
         if (delegatee != null && ! (delegatee instanceof LayoutDelegatee))
         {
            throw new IllegalArgumentException ("Delegatee not of type DecoratorLayout.LayoutDelegatee");
         }

         if (layoutComponents == null)
         {
            layoutComponents = new HashMap();
         }

         layoutComponents.put (comp, delegatee);
      }
   }


   /**
    * UMLMethod: '+ removeLayoutComponent (comp : Component) : Void'
    *
    * @param comp  No description provided
    */
   public void removeLayoutComponent (Component comp)
   {
      if (comp != null)
      {
         if (layoutComponents != null)
         {
            layoutComponents.remove (comp);
         }
      }
   }


   /**
    * UMLMethod: '+ preferredLayoutSize (parent : Container) : Dimension'
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Dimension preferredLayoutSize (Container parent)
   {
      Dimension dim = new Dimension (1, 1);
      Point origin = new Point (0, 0);
      Component[] components = parent.getComponents();
      Rectangle bounds = null;

      for (int i = 0; i < components.length; i++)
      {
         Component comp = components[i];
         LayoutDelegatee delegatee = getDelegateeFromLayoutComponents (comp);
         if (delegatee != null)
         {
            bounds = delegatee.getPreferredBounds (comp, parent);
         }
         else
         {
            if (bounds == null)
            {
               bounds = new Rectangle();
            }

            bounds.setSize (comp.getPreferredSize());
            bounds.setLocation (comp.getLocation());
         }

         if (bounds.x < origin.x)
         {
            dim.width += origin.x - bounds.x;
            origin.x = bounds.x;
         }
         else
         {
            dim.width = Math.max (dim.width, bounds.x - origin.x + bounds.width);
         }

         if (bounds.y < origin.y)
         {
            dim.height += origin.y - bounds.y;
            origin.y = bounds.y;
         }
         else
         {
            dim.height = Math.max (dim.height, bounds.y - origin.y + bounds.height);
         }
      }

      return dim;
   }


   /**
    * UMLMethod: '+ minimumLayoutSize (parent : Container) : Dimension'
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Dimension minimumLayoutSize (Container parent)
   {
      return preferredLayoutSize (parent);
   }


   /**
    * UMLMethod: '+ maximumLayoutSize (target : Container) : Dimension'
    *
    * @param target  No description provided
    * @return        No description provided
    */
   public Dimension maximumLayoutSize (Container target)
   {
      return preferredLayoutSize (target);
   }


   /**
    * UMLMethod: '+ getLayoutAlignmentX (target : Container) : Float'
    *
    * @param target  No description provided
    * @return        The layoutAlignmentX value
    */
   public float getLayoutAlignmentX (Container target)
   {
      return 0.5f;
   }


   /**
    * UMLMethod: '+ getLayoutAlignmentY (target : Container) : Float'
    *
    * @param target  No description provided
    * @return        The layoutAlignmentY value
    */
   public float getLayoutAlignmentY (Container target)
   {
      return 0.5f;
   }


   /**
    * UMLMethod: '+ layoutContainer (parent : Container) : Void'
    *
    * @param parent  No description provided
    */
   public void layoutContainer (Container parent)
   {
      Component[] components = parent.getComponents();
      Rectangle bounds = null;

      for (int i = 0; i < components.length; i++)
      {
         Component comp = components[i];

         LayoutDelegatee delegatee = getDelegateeFromLayoutComponents (comp);
         if (delegatee != null)
         {
            bounds = delegatee.getPreferredBounds (comp, parent);
         }
         else
         {
            bounds = new Rectangle();
            bounds.setLocation (comp.getLocation());

            bounds.setSize (comp.getPreferredSize());
         }
      }
   }


   /**
    * UMLMethod: '+ invalidateLayout (target : Container) : Void'
    *
    * @param target  No description provided
    */
   public void invalidateLayout (Container target)
   {
      /*
       *  if (log.isInfoEnabled()) log.info ("\nvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
       *  if (log.isInfoEnabled()) log.info (this + ".invalidateLayout(" + target + ")");
       *  de.uni_paderborn.fujaba.basic.FD.printStackTrace (5);
       *  if (log.isInfoEnabled()) log.info ("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n");
       */
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: mksoft $
    * @version   $Revision: 1.12.2.1 $
    */
   public static interface LayoutDelegatee
   {
      /**
       * Get the preferredBounds attribute of the LayoutDelegatee object
       *
       * @param comp    No description provided
       * @param parent  No description provided
       * @return        The preferredBounds value
       */
      public Rectangle getPreferredBounds (Component comp, Container parent);
   }
}

/*
 * $Log: DelegationLayout.java,v $
 * Revision 1.12.2.1  2005/09/30 18:57:07  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
