/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;
import javax.swing.plaf.ComponentUI;


/**
 * This is the UI used by JLines by default. It realizes a single straight line. Use createUI()
 * to get an instance of this class.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.10 $
 */
public class DefaultLineUI extends LineUI
{
   /**
    * This class is a singleton. This is the object of it.
    */
   private static DefaultLineUI ui = null;


   /**
    * Returns an instance of this class for the given JComponent.
    *
    * @param c  the JComponent the LineUI should be returned for.
    * @return   An instance of this class.
    */
   public static ComponentUI createUI (JComponent c)
   {
      if (ui == null)
      {
         ui = new DefaultLineUI();
      }
      return ui;
   }


   /**
    * Protected default constructor. Should be only used by subclasses. If you want to obtain
    * an instance of this class, use createUI()
    */
   protected DefaultLineUI() { }


   /**
    * Returns the preferred bounds of the given JComponent, using the start and end points
    * of the JComponent.
    *
    * @param line  No description provided
    * @return      a rectangle with the preferred bounds of the given component.
    */
   public Rectangle getPreferredLineBounds (JLine line)
   {
      Point startPoint = line.getStartPoint();
      Point endPoint = line.getEndPoint();
      double delta = line.getDelta();

      if (startPoint == null)
      {
         startPoint = line.getLocation();
      }

      if (endPoint == null)
      {
         endPoint = line.getLocation();
      }

      return new Rectangle (
         (int) Math.min (startPoint.x - delta, endPoint.x - delta),
         (int) Math.min (startPoint.y - delta, endPoint.y - delta),
         (int)  (Math.abs (startPoint.x - endPoint.x) + 2 * delta),
         (int)  (Math.abs (startPoint.y - endPoint.y) + 2 * delta)
         );
   }


   /**
    * Draws the line for the given JLine. For this class, a single straight line is drawn
    *
    * @param g     No description provided
    * @param line  No description provided
    */
   public void paintLine (Graphics g, JLine line)
   {
      Color oldColor = g.getColor();

      Point start = line.getStartPoint();
      Point end = line.getEndPoint();
      Point loc = line.getLocation();

      g.setColor (line.getForeground());

      g.drawLine (start.x - loc.x, start.y - loc.y, end.x - loc.x, end.y - loc.y);

      g.setColor (oldColor);
   }

}

/*
 * $Log: DefaultLineUI.java,v $
 * Revision 1.10  2004/11/03 10:17:56  lowende
 * Javadoc warnings removed.
 *
 */
