/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;
import javax.swing.plaf.ComponentUI;


/**
 * default UI for bends. </p> small filled rectangle with bendPoint in the center
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.9 $
 */
public class DefaultBendUI extends BendUI
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEFAULT_SIZE = 3;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static DefaultBendUI ui = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static DefaultBendUI get()
   {
      if (ui == null)
      {
         ui = new DefaultBendUI();
      }
      return ui;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param c  No description provided
    * @return   No description provided
    */
   public static ComponentUI createUI (JComponent c)
   {
      return get();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param g  No description provided
    * @param c  No description provided
    */
   public void paint (Graphics g, JComponent c)
   {
      Color oldColor = g.getColor();
      Dimension size = c.getSize();

      // fill rectangle (0,0,radius*2,radius*2) with color
      g.setColor (c.getForeground());

      g.fillRect (0, 0, size.width, size.height);

      g.setColor (oldColor);
   }


   /**
    * Get the preferredSize attribute of the DefaultBendUI object
    *
    * @param c  No description provided
    * @return   The preferredSize value
    */
   public Dimension getPreferredSize (JComponent c)
   {
      Dimension size = c.getSize();
      return new Dimension (Math.max (size.width, DEFAULT_SIZE), Math.max (size.height, DEFAULT_SIZE));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param c  No description provided
    * @return   No description provided
    */
   protected Point calculatePoint (JComponent c)
   {
      Rectangle bounds = c.getBounds();

      return new Point ((int) bounds.getCenterX(), (int) bounds.getCenterY());
   }
}

/*
 * $Log: DefaultBendUI.java,v $
 * Revision 1.9  2004/11/03 10:17:56  lowende
 * Javadoc warnings removed.
 *
 */
