/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;
import java.util.*;

import de.upb.tools.fca.FTreeMap;


/**
 * $Id: ColumnRowLayout.java,v 1.22 2004/10/20 17:49:44 schneider Exp $ This LayoutManager layouts
 * the components in a column or a row without changing their sizes. This LayoutManager was
 * written as an replacement for the GridLayout with one row or one column.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.22 $
 */
public class ColumnRowLayout extends Object implements SortedLayout
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected int gap;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected int mode;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int ROW = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int COLUMN = 1;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected FTreeMap alignments = new FTreeMap();

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int LEFT = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int RIGHT = 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int CENTER = 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String delimiter = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JDelimiter swingDelim = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Comparator comparator = null;


   /**
    * Sets the comparator attribute of the ColumnRowLayout object
    *
    * @param comp  The new comparator value
    */
   public void setComparator (Comparator comp)
   {
      if ( (this.comparator == null && comp != null) ||
          (this.comparator != null && !this.comparator.equals (comp)))
      {
         this.comparator = comp;
      } // end of if ()
   }


   /**
    * Get the comparator attribute of the ColumnRowLayout object
    *
    * @return   The comparator value
    */
   public Comparator getComparator()
   {
      return this.comparator;
   }


   /**
    * Sets the delimiter attribute of the ColumnRowLayout object
    *
    * @param delim  The new delimiter value
    */
   public void setDelimiter (String delim)
   {
      if ( (this.delimiter == null && delim != null) ||
          (this.delimiter != null && !this.delimiter.equals (delim)))
      {
         this.delimiter = delim;
      } // end of if ()
   }


   /**
    * Get the delimiter attribute of the ColumnRowLayout object
    *
    * @return   The delimiter value
    */
   public String getDelimiter()
   {
      return this.delimiter;
   }


   /**
    * Constructor for class ColumnRowLayout
    */
   public ColumnRowLayout() { }


   /**
    * You must specify the gap between the objects and how you would like the the Layouter
    * do his work. The Layouter can layout the objects in a row or in a column.
    *
    * @param aGap   No description provided
    * @param aMode  No description provided
    */

   public ColumnRowLayout (int aGap, int aMode)
   {
      gap = aGap;
      mode = aMode;
   }


   /**
    * Sets the alignment attribute of the ColumnRowLayout object
    *
    * @param pos    The new alignment value
    * @param align  The new alignment value
    */
   public void setAlignment (int pos, int align)
   {
      alignments.put (new Integer (pos), new Integer (align));
   }


   /**
    * Access method for an one to n association.
    *
    * @param name  The object added.
    * @param comp  The object added.
    */
   public void addLayoutComponent (String name, Component comp) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comp  No description provided
    */
   public void removeLayoutComponent (Component comp) { }


   /**
    * This method calculates the preferredSize of the Container. Between the objects and around
    * them is the gap.
    *
    * @param parent  No description provided
    * @return        No description provided
    */
   public Dimension preferredLayoutSize (Container parent)
   {
      if (delimiter != null && swingDelim == null)
      {
         swingDelim = new JDelimiter (getDelimiter());
      } // end of if ()
      else
      {
         if (delimiter == null)
         {
            swingDelim = null;
         } // end of if ()
      } // end of else

      Vector toBeRemoved = new Vector();
      Vector toBeAdded = new Vector();
      Component comp[] = parent.getComponents();
      Insets insets = parent.getInsets();
      int i;

      int height = 0;
      int width = 0;
      Dimension tempDim;
      int compCount = 0;

      for (i = 0; i < comp.length; i++)
      {
         if (!comp[i].isVisible())
         {
            continue;
         }

         if ( (comp[i] instanceof JDelimiter))
         {
            if (delimiter == null)
            {
               toBeRemoved.add (comp[i]);
            } // end of if ()
            continue;
         } // end of if ()

         if (delimiter != null && i + 1 < comp.length &&
            ! (comp[i + 1] instanceof JDelimiter))
         {
            toBeAdded.add (new Integer (i + 1));
         } // end of if ()

         compCount++;

         tempDim = comp[i].getPreferredSize();

         if (tempDim != null)
         {
            if (mode == COLUMN)
            {
               if (tempDim.width > width)
               {
                  width = tempDim.width;
               }

               if (delimiter != null && swingDelim != null)
               {
                  Dimension hlpDim = swingDelim.getPreferredSize();
                  height = height + hlpDim.height;
               }
               height = height + tempDim.height;
            }
            else
            {
               if (tempDim.height > height)
               {
                  height = tempDim.height;
               }

               if (delimiter != null && swingDelim != null)
               {
                  Dimension hlpDim = swingDelim.getPreferredSize();
                  width = width + hlpDim.width;
               }
               width = width + tempDim.width;
            }

         } // end of if ()

// This lines produce display errors when using this layouter for
// state charts. Is there any reason for this calculation?
// rw
//         if ( (comp[i] instanceof javax.swing.JSeparator))
//         {
//            height -= gap;
//         }
      }

      Iterator iter = toBeRemoved.iterator();
      while (iter.hasNext())
      {
         Component hlpComp = (Component) iter.next();
         parent.remove (hlpComp);
      } // end of while ()
      toBeRemoved.clear();

      int hlpCount = 0;
      iter = toBeAdded.iterator();
      while (iter.hasNext())
      {
         Integer indexObj = (Integer) iter.next();
         int index = indexObj.intValue() + hlpCount;

         JDelimiter delim = new JDelimiter (getDelimiter());
         delim.setFont (parent.getFont());

         parent.add (delim, index);
         hlpCount = hlpCount + 1;
      } // end of while ()
      toBeAdded.clear();

      if (compCount > 0)
      {
         if (mode == COLUMN)
         {
            height +=  (compCount + 1) * gap;
            width += 2 * gap;
         }
         else
         {
            width +=  (compCount + 1) * gap;
            height += 2 * gap;
         }
      }

      return new Dimension (width + insets.left + insets.right, height + insets.top + insets.bottom);
   }


   /**
    * The minimumLayout Size is for this LayoutManager the same as the preferredLayoutSize.
    *
    * @param parent  No description provided
    * @return        No description provided
    */

   public Dimension minimumLayoutSize (Container parent)
   {
      return preferredLayoutSize (parent);
   }


   /**
    * This method moves the objects to their places and set the sizes they prefer.
    *
    * @param parent  No description provided
    */
   public void layoutContainer (Container parent)
   {
      Dimension dim = null;
      Rectangle rect = parent.getBounds();
      if (rect == null)
      {
         dim = preferredLayoutSize (parent);
      } // end of if ()
      else
      {
         dim = new Dimension (rect.width, rect.height);
      } // end of else

      Component comp[] = parent.getComponents();
      Insets insets = parent.getInsets();

      int x = gap + insets.left;
      int y = gap + insets.top;

      int i;

      int maxWidth = dim.width - insets.left - insets.right - 2 * gap;
      int maxHeight = dim.height - insets.top - insets.bottom - 2 * gap;
      Dimension tempDim;
      Integer pos = null;

      if (this.comparator != null)
      {
         Arrays.sort (comp, this.comparator);
      }

      for (i = 0; i < comp.length; i++)
      {
         int align = LEFT;
         int tmpX = x;
         if (!comp[i].isVisible())
         {
            continue;
         }

         tempDim = comp[i].getPreferredSize();

         if (comp[i] instanceof javax.swing.JSeparator)
         {
            comp[i].setLocation (x - gap, y - gap / 2);
            y -= gap / 2;
         }
         else
         {
            pos = new Integer (i);
            if (mode == COLUMN && alignments.get (pos) != null)
            {
               Integer alignment = (Integer) alignments.get (pos);
               align = alignment.intValue();

               if (align == CENTER)
               {
                  tmpX = (int)  (dim.getWidth() - tempDim.getWidth()) / 2;
               } // end of if ()
            } // end of if ()
            comp[i].setLocation (tmpX, y);
         } // end of else

         if (mode == COLUMN)
         {
            if (comp[i] instanceof javax.swing.JSeparator)
            {
               comp[i].setSize (maxWidth + 2 * gap, tempDim.height);
            }
            else
            {
               if (align != CENTER)
               {
                  comp[i].setSize (maxWidth, tempDim.height);
               } // end of else
               else
               {
                  comp[i].setSize (tempDim.width, tempDim.height);
               } // end of else

            }
            y = y + tempDim.height + gap;
         }
         else
         {
            comp[i].setSize (tempDim.width, maxHeight);
            x = x + tempDim.width + gap;
         } // end of else
      }

   }
}

/*
 * $Log: ColumnRowLayout.java,v $
 * Revision 1.22  2004/10/20 17:49:44  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
