/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.*;

import javax.swing.*;
import javax.swing.plaf.PanelUI;


/**
 * Base UI for JBends
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 */
public abstract class BendUI extends PanelUI
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param g  No description provided
    * @param c  No description provided
    */
   public abstract void paint (Graphics g, JComponent c);


   /**
    * Get the preferredSize attribute of the BendUI object
    *
    * @param c  No description provided
    * @return   The preferredSize value
    */
   public abstract Dimension getPreferredSize (JComponent c);


   /**
    * calculate the point where the line should attach to the bend. called by JBend whenever
    * the bounds of the bend change.
    *
    * @param b  No description provided
    * @return   No description provided
    */
   protected abstract Point calculatePoint (JComponent b);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param bend          No description provided
    * @param propertyName  No description provided
    * @param oldValue      No description provided
    * @param newValue      No description provided
    */
   protected void firePropertyChange (JBend bend, String propertyName, boolean oldValue, boolean newValue)
   {
      if (oldValue != newValue)
      {
         firePropertyChange (bend, propertyName, Boolean.valueOf (oldValue), Boolean.valueOf (newValue));
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param bend          No description provided
    * @param propertyName  No description provided
    * @param oldValue      No description provided
    * @param newValue      No description provided
    */
   protected void firePropertyChange (JBend bend, String propertyName, byte oldValue, byte newValue)
   {
      if (oldValue != newValue)
      {
         firePropertyChange (bend, propertyName, new Byte (oldValue), new Byte (newValue));
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param bend          No description provided
    * @param propertyName  No description provided
    * @param oldValue      No description provided
    * @param newValue      No description provided
    */
   protected void firePropertyChange (JBend bend, String propertyName, char oldValue, char newValue)
   {
      if (oldValue != newValue)
      {
         firePropertyChange (bend, propertyName, new Character (oldValue), new Character (newValue));
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param bend          No description provided
    * @param propertyName  No description provided
    * @param oldValue      No description provided
    * @param newValue      No description provided
    */
   protected void firePropertyChange (JBend bend, String propertyName, double oldValue, double newValue)
   {
      if (oldValue != newValue)
      {
         firePropertyChange (bend, propertyName, new Double (oldValue), new Double (newValue));
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param bend          No description provided
    * @param propertyName  No description provided
    * @param oldValue      No description provided
    * @param newValue      No description provided
    */
   protected void firePropertyChange (JBend bend, String propertyName, float oldValue, float newValue)
   {
      if (oldValue != newValue)
      {
         firePropertyChange (bend, propertyName, new Float (oldValue), new Float (newValue));
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param bend          No description provided
    * @param propertyName  No description provided
    * @param oldValue      No description provided
    * @param newValue      No description provided
    */
   protected void firePropertyChange (JBend bend, String propertyName, int oldValue, int newValue)
   {
      if (oldValue != newValue)
      {
         firePropertyChange (bend, propertyName, new Integer (oldValue), new Integer (newValue));
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param bend          No description provided
    * @param propertyName  No description provided
    * @param oldValue      No description provided
    * @param newValue      No description provided
    */
   protected void firePropertyChange (JBend bend, String propertyName, long oldValue, long newValue)
   {
      if (oldValue != newValue)
      {
         firePropertyChange (bend, propertyName, new Long (oldValue), new Long (newValue));
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param bend          No description provided
    * @param propertyName  No description provided
    * @param oldValue      No description provided
    * @param newValue      No description provided
    */
   protected void firePropertyChange (JBend bend, String propertyName, Object oldValue, Object newValue)
   {
      if (bend == null)
      {
         return;
      }

      if ( (oldValue == null && newValue != null) ||  (oldValue != null && !oldValue.equals (newValue)))
      {
         bend.firePropertyChange (propertyName, oldValue, newValue);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param bend          No description provided
    * @param propertyName  No description provided
    * @param oldValue      No description provided
    * @param newValue      No description provided
    */
   protected void firePropertyChange (JBend bend, String propertyName, short oldValue, short newValue)
   {
      if (oldValue != newValue)
      {
         firePropertyChange (bend, propertyName, new Short (oldValue), new Short (newValue));
      }
   }
}

/*
 * $Log: BendUI.java,v $
 * Revision 1.10  2004/10/20 17:49:44  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
