/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;

import javax.swing.*;
import javax.swing.event.MouseInputAdapter;

import de.uni_paderborn.fujaba.fsa.SelectionManager;


/**
 * Handles selecting of Objects as well as putting selected Objects on top of others
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.16 $
 */
public class SelectionMouseListener extends MouseInputAdapter
    implements AscendDescendMouseHandler.Ascend, AscendDescendMouseHandler.Descend
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static SelectionMouseListener singleton = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static SelectionMouseListener get()
   {
      if (singleton == null)
      {
         singleton = new SelectionMouseListener();
      }

      return singleton;
   }


   /**
    * The default constructor is empty.
    */
   protected SelectionMouseListener() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected boolean deleteSelection = false;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected boolean multi = false;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected boolean consume = false;


   /**
    * Overwrites the mousePressed method of ComponentMouseListener. It sets the lastPoint attribute.
    *
    * @param e  No description provided
    */
   public void mousePressed (MouseEvent e)
   {
      if (!AscendDescendMouseHandler.isADMouseEvent (e) ||
      //AscendDescendMouseHandler.isAscendMouseEvent (e))
         AscendDescendMouseHandler.isDescendMouseEvent (e))
      {
         JComponent comp = (JComponent) e.getSource();

         comp.requestFocus();

         boolean selected = SelectionManager.get().isSelected (comp);
         deleteSelection = SelectionManager.get().isFocused (comp);
         consume = !deleteSelection;

         multi =  (e.getModifiers() & InputEvent.CTRL_MASK) > 0 ||
             (e.getModifiers() & InputEvent.SHIFT_MASK) > 0;

         if (multi)
         {
            if (!deleteSelection)
            {
               SelectionManager.get().setFocused (comp, true);
            }
         }
         else
         {
            multi = false;
            if (!selected || !deleteSelection)
            {
               SelectionManager.get().setSelected (comp, true);
            }
         }

         Container parent = comp.getParent();
         if (parent != null && parent instanceof JLayeredPane)
         {
            JLayeredPane pane = (JLayeredPane) parent;

            pane.setPosition (comp, 0);
            pane.repaint();
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mouseReleased (MouseEvent e)
   {
      if (!AscendDescendMouseHandler.isADMouseEvent (e) ||
         AscendDescendMouseHandler.isDescendMouseEvent (e))
      {
         JComponent comp = (JComponent) e.getSource();

         if (deleteSelection)
         {
            SelectionManager.get().setSelected (comp, !multi, multi);
         }
         multi = false;
      }
   } // mouseReleased


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mouseDragged (MouseEvent e)
   {
      if (!AscendDescendMouseHandler.isADMouseEvent (e) ||
         AscendDescendMouseHandler.isDescendMouseEvent (e))
      {
         deleteSelection = false;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void mouseClicked (MouseEvent e)
   {
      if (e.getClickCount() == 1 && consume)
      {
         e.consume();
         consume = false;
      }
   }
}

/*
 * $Log: SelectionMouseListener.java,v $
 * Revision 1.16  2004/11/03 10:17:55  lowende
 * Javadoc warnings removed.
 *
 */
