/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;

import javax.swing.*;

import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FLinkedList;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.13 $
 */
public abstract class SelectionListenerHelper
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static transient Integer UNSELECTED = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static transient Integer SELECTED = new Integer (1);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static transient Integer FOCUSED = new Integer (2);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static transient Integer FOCUSED_SELECTED = new Integer (3);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static transient String LISTENER_CLIENT_PROPERTY =
      SelectionListener.class.getName() + "::listeners";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   final static transient String STATE_CLIENT_PROPERTY =
      SelectionListener.class.getName() + "::state";


   /**
    * Access method for an one to n association.
    *
    * @param comp      The object added.
    * @param listener  The object added.
    */
   public static void addSelectionListener (JComponent comp, SelectionListener listener)
   {
      Object o = comp.getClientProperty (LISTENER_CLIENT_PROPERTY);
      FLinkedList listeners = null;

      if (o != null)
      {
         if (o instanceof FLinkedList)
         {
            listeners = (FLinkedList) o;
         }
         else
         {
            throw new IllegalStateException ("The component has a conflicting client property with name \"" + LISTENER_CLIENT_PROPERTY + "\": " + o);
         }
      }
      else
      {
         listeners = new FLinkedList();
         comp.putClientProperty (LISTENER_CLIENT_PROPERTY, listeners);
      }

      listeners.add (listener);
      if (listeners.size() == 1)
      {
         comp.addPropertyChangeListener (STATE_CLIENT_PROPERTY, getSelectionStateListener());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comp      No description provided
    * @param listener  No description provided
    * @return          No description provided
    */
   public static boolean removeSelectionListener (JComponent comp, SelectionListener listener)
   {
      Object o = comp.getClientProperty (LISTENER_CLIENT_PROPERTY);
      FLinkedList listeners = null;
      boolean result = false;

      if (o != null)
      {
         if (o instanceof FLinkedList)
         {
            listeners = (FLinkedList) o;
            result = listeners.remove (listener);
            if (result && listeners.size() == 0)
            {
               comp.putClientProperty (LISTENER_CLIENT_PROPERTY, null);
               comp.removePropertyChangeListener (STATE_CLIENT_PROPERTY, getSelectionStateListener());
            }
         }
      }
      return result;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comp  No description provided
    * @return      No description provided
    */
   public static Iterator iteratorOfSelectionListeners (JComponent comp)
   {
      Object o = comp.getClientProperty (LISTENER_CLIENT_PROPERTY);

      if (o != null)
      {
         if (o instanceof FLinkedList)
         {
            FLinkedList listeners = (FLinkedList) o;
            return listeners.iterator();
         }
      }
      return FEmptyIterator.get();
   }


   /**
    * Get the selection attribute of the SelectionListenerHelper class
    *
    * @param comp  No description provided
    * @return      The selection value
    */
   public static int getSelection (JComponent comp)
   {
      Object o = comp.getClientProperty (STATE_CLIENT_PROPERTY);

      if (o != null)
      {
         if (o instanceof Integer)
         {
            return  ((Integer) o).intValue();
         }
         else
         {
            throw new IllegalStateException ("The component has a conflicting client property with name \"" + STATE_CLIENT_PROPERTY + "\": " + o);
         }
      }
      return 0;
   }


   /**
    * Sets the selection attribute of the SelectionListenerHelper class
    *
    * @param comp       The new selection value
    * @param selection  The new selection value
    */
   public static void setSelection (JComponent comp, int selection)
   {
      switch (selection)
      {
         case 0:
            setSelection (comp, UNSELECTED);
            break;
         case 1:
            setSelection (comp, SELECTED);
            break;
         case 2:
            setSelection (comp, FOCUSED);
            break;
         case 3:
            setSelection (comp, FOCUSED_SELECTED);
            break;
         default:
            throw new IllegalArgumentException ("Selection Parameter must be in [0..3], is " + selection);
      }
   }


   /**
    * Sets the selection attribute of the SelectionListenerHelper class
    *
    * @param comp       The new selection value
    * @param selection  The new selection value
    */
   protected static void setSelection (JComponent comp, Integer selection)
   {
      Object o = comp.getClientProperty (STATE_CLIENT_PROPERTY);

      if (o == null || o instanceof Integer)
      {
         comp.putClientProperty (STATE_CLIENT_PROPERTY, selection);
      }
      else
      {
         throw new IllegalStateException ("The component has a conflicting client property with name \"" + STATE_CLIENT_PROPERTY + "\": " + o);
      }
   }


   /**
    * Get the selected attribute of the SelectionListenerHelper class
    *
    * @param comp  No description provided
    * @return      The selected value
    */
   public static boolean isSelected (JComponent comp)
   {
      return  ( (comp != null) &&  ( (getSelection (comp) & SelectionEvent.SELECTION_FLAG) != 0));
   }


   /**
    * Sets the selected attribute of the SelectionListenerHelper class
    *
    * @param comp  The new selected value
    * @param flag  The new selected value
    */
   public static void setSelected (JComponent comp, boolean flag)
   {
      int state = getSelection (comp);
      if (flag !=  ( (state & SelectionEvent.SELECTION_FLAG) != 0))
      {
         state = state ^ SelectionEvent.SELECTION_FLAG;
         setSelection (comp, state);
      }
   }


   /**
    * Get the focused attribute of the SelectionListenerHelper class
    *
    * @param comp  No description provided
    * @return      The focused value
    */
   public static boolean isFocused (JComponent comp)
   {
      return  ( (comp != null) &&  ( (getSelection (comp) & SelectionEvent.FOCUS_FLAG) != 0));
   }


   /**
    * Sets the focused attribute of the SelectionListenerHelper class
    *
    * @param comp  The new focused value
    * @param flag  The new focused value
    */
   public static void setFocused (JComponent comp, boolean flag)
   {
      int state = getSelection (comp);
      if (flag !=  ( (state & SelectionEvent.FOCUS_FLAG) != 0))
      {
         state = state ^ SelectionEvent.FOCUS_FLAG;
         setSelection (comp, state);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   protected static void fireSelectionChanged (SelectionEvent event)
   {
      JComponent source = (JComponent) event.getSource();
      Iterator iter = iteratorOfSelectionListeners (source);
      while (iter.hasNext())
      {
         SelectionListener l = (SelectionListener) iter.next();

         l.selectionChanged (event);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param source     No description provided
    * @param old        No description provided
    * @param selection  No description provided
    */
   protected static void fireSelectionChanged (JComponent source, Integer old, Integer selection)
   {
      int oldSel =  (old == null ? 0 : old.intValue());
      int newSel =  (selection == null ? 0 : selection.intValue());

      SelectionEvent event = new SelectionEvent (source, oldSel, newSel);
      fireSelectionChanged (event);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static transient PropertyChangeListener selectionStateListener;


   /**
    * Get the selectionStateListener attribute of the SelectionListenerHelper class
    *
    * @return   The selectionStateListener value
    */
   protected static PropertyChangeListener getSelectionStateListener()
   {
      if (selectionStateListener == null)
      {
         selectionStateListener = new SelectionStateListener();
      }
      return selectionStateListener;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: schneider $
    * @version   $Revision: 1.13 $
    */
   private final static class SelectionStateListener implements PropertyChangeListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param evt  No description provided
       */
      public void propertyChange (PropertyChangeEvent evt)
      {
         if (STATE_CLIENT_PROPERTY.equals (evt.getPropertyName()))
         {
            Integer oldValue = (Integer) evt.getOldValue();
            Integer newValue = (Integer) evt.getNewValue();
            JComponent source = (JComponent) evt.getSource();

            if (oldValue == null && newValue != null ||  (oldValue != null && !oldValue.equals (newValue)))
            {
               fireSelectionChanged (source, oldValue, newValue);
            }
         }
      }
   }
}

/*
 * $Log: SelectionListenerHelper.java,v $
 * Revision 1.13  2004/10/20 17:49:43  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
