/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.event.ComponentEvent;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.10 $
 */
public class SelectionEvent extends ComponentEvent
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int SELECTION_FLAG = 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int FOCUS_FLAG = 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int oldSelection = -1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int newSelection = -1;


   /**
    * Constructor for class SelectionEvent
    *
    * @param source        No description provided
    * @param oldSelection  No description provided
    * @param newSelection  No description provided
    */
   public SelectionEvent (JComponent source, int oldSelection, int newSelection)
   {
      super (source, -1);
      this.oldSelection = oldSelection;
      this.newSelection = newSelection;
   }


   /**
    * Get the selected attribute of the SelectionEvent object
    *
    * @return   The selected value
    */
   public boolean isSelected()
   {
      return  ( (newSelection & SELECTION_FLAG) != 0);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public boolean wasSelected()
   {
      return  ( (oldSelection & SELECTION_FLAG) != 0);
   }


   /**
    * Get the selectionChanged attribute of the SelectionEvent object
    *
    * @return   The selectionChanged value
    */
   public boolean isSelectionChanged()
   {
      return  (isSelected() != wasSelected());
   }


   /**
    * Get the focused attribute of the SelectionEvent object
    *
    * @return   The focused value
    */
   public boolean isFocused()
   {
      return  ( (newSelection & FOCUS_FLAG) != 0);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public boolean wasFocused()
   {
      return  ( (oldSelection & FOCUS_FLAG) != 0);
   }


   /**
    * Get the focusChanged attribute of the SelectionEvent object
    *
    * @return   The focusChanged value
    */
   public boolean isFocusChanged()
   {
      return  (isFocused() != wasFocused());
   }


   /**
    * Get the selectFlags attribute of the SelectionEvent object
    *
    * @return   The selectFlags value
    */
   public int getSelectFlags()
   {
      return  (oldSelection ^ newSelection);
   }


   /**
    * Get the selection attribute of the SelectionEvent object
    *
    * @return   The selection value
    */
   public int getSelection()
   {
      return newSelection;
   }


   /**
    * Get the oldSelection attribute of the SelectionEvent object
    *
    * @return   The oldSelection value
    */
   public int getOldSelection()
   {
      return oldSelection;
   }
}

/*
 * $Log: SelectionEvent.java,v $
 * Revision 1.10  2004/11/03 10:17:55  lowende
 * Javadoc warnings removed.
 *
 */
