/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.*;
import java.awt.event.MouseEvent;

import javax.swing.*;


/**
 * This listener is responsible to set the cursor of a resizable component.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12 $
 */
public class ComponentCursorListener extends ComponentMouseListener implements AscendDescendMouseHandler.Ascend
{
   /**
    * The attribute to implement the Singleton design pattern. Only one system wide instance
    * of this kind of listener is needed.
    */
   private static ComponentCursorListener listener = null;


   /**
    * The private constructor to implement the Singleton design pattern.
    */
   private ComponentCursorListener() { }


   /**
    * The public method to get the singleton instance.
    *
    * @return   No description provided
    */
   public static ComponentCursorListener get()
   {
      if (listener == null)
      {
         listener = new ComponentCursorListener();
      } // end of if ()
      return listener;
   }


   /**
    * Internal used array to set the different cursors when the mouse is moved on a component.
    */
   private Cursor[] cursors = {new Cursor (Cursor.NW_RESIZE_CURSOR),
      new Cursor (Cursor.NE_RESIZE_CURSOR),
      new Cursor (Cursor.N_RESIZE_CURSOR),
      new Cursor (Cursor.SW_RESIZE_CURSOR),
      new Cursor (Cursor.SE_RESIZE_CURSOR),
      new Cursor (Cursor.S_RESIZE_CURSOR),
      new Cursor (Cursor.W_RESIZE_CURSOR),
      new Cursor (Cursor.E_RESIZE_CURSOR),
      new Cursor (Cursor.DEFAULT_CURSOR)};

   /**
    * Internal used attribute to store the cursor of the component before it is changed by
    * this listener.
    */
   private Cursor lastCursor = null;


   /**
    * Internal used method to set the cursor of the component.
    *
    * @param comp   The new cursorOfComponent value
    * @param event  The new cursorOfComponent value
    */
   private void setCursorOfComponent (Component comp, MouseEvent event)
   {
      if (lastComponent != comp)
      {
         if (lastComponent != null)
         {
            lastComponent.setCursor (lastCursor);
         } // end of if ()
         lastComponent = comp;
         lastCursor = lastComponent.getCursor();
      } // end of if ()

      setOrientation (comp, event);
      final int orientation = getOrientation();

      if (orientation == NORTH + EAST)
      {
         comp.setCursor (cursors[0]);
      }
      else if (orientation == NORTH + WEST)
      {
         comp.setCursor (cursors[1]);
      }
      else if (orientation == NORTH)
      {
         comp.setCursor (cursors[2]);
      }
      else if (orientation == SOUTH + EAST)
      {
         comp.setCursor (cursors[3]);
      }
      else if (orientation == SOUTH + WEST)
      {
         comp.setCursor (cursors[4]);
      }
      else if (orientation == SOUTH)
      {
         comp.setCursor (cursors[5]);
      }
      else if (orientation == EAST)
      {
         comp.setCursor (cursors[6]);
      }
      else if (orientation == WEST)
      {
         comp.setCursor (cursors[7]);
      }
      else
      {
         lastComponent.setCursor (lastCursor);
      } // end of else
   }


   /**
    * Overwrites the mouseEntered method of ComponentMouseListener. An entered event sets the
    * cursor of the component by calling the internal method setCursorOfComponent.
    *
    * @param event  No description provided
    */
   public void mouseEntered (MouseEvent event)
   {
      JComponent comp = (JComponent) event.getSource();
      setCursorOfComponent (comp, event);
   }


   /**
    * Overwrites the mouseExited method of ComponentMouseListener. An exited event sets the
    * cursor of the component by calling the internal method setCursorOfComponent.
    *
    * @param event  No description provided
    */
   public void mouseExited (MouseEvent event)
   {
      JComponent comp = (JComponent) event.getSource();
      setCursorOfComponent (comp, event);
   }


   /**
    * Overwrites the mouseMoved method of ComponentMouseListener. A moved event sets the cursor
    * of the component by calling the internal method setCursorOfComponent.
    *
    * @param event  No description provided
    */
   public void mouseMoved (MouseEvent event)
   {
      JComponent comp = (JComponent) event.getSource();
      setCursorOfComponent (comp, event);
   }
}

/*
 * $Log: ComponentCursorListener.java,v $
 * Revision 1.12  2004/11/03 10:17:54  lowende
 * Javadoc warnings removed.
 *
 */
