/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Iterator;

import javax.swing.JComponent;

import de.uni_paderborn.fujaba.fsa.SelectionManager;


/**
 * This class implements the handling of Arrow-Keys for moving FSAObjects around. For each
 * key_type event the selected objects are moved. Additionally each time the mouse is clicked
 * on the pane, the class requests focus to receive the key events.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.16.2.1 $
 */
public class ArrowMoveListener implements KeyListener, SelectionListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static ArrowMoveListener singleton;


   /**
    * Constructor for class ArrowMoveListener
    */
   private ArrowMoveListener() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static ArrowMoveListener get()
   {
      if (singleton == null)
      {
         singleton = new ArrowMoveListener();
      }
      return singleton;
   }


   /**
    * Nothing will be done on this event.
    *
    * @param event  KeyEvent
    */
   public void keyTyped (KeyEvent event)
   {
   }


   /**
    * All selected objects will be moved according to the cursor keys. If no object is selected
    * the event will not be consumed and the scrollbars will receive the event and act accordingly.
    *
    * <ol>Modifiers
    *   <li> Shift: 10 units</li>
    *   <li> Ctrl: 2 units</li>
    *   <li> no: 1 unit</li>
    * </ol>
    *
    * @param event  KeyEvent
    */
   public void keyPressed (KeyEvent event)
   {
      boolean arrowKey = false;

      int modifier = 1;

      if (event.isControlDown())
      {
         modifier = 2;
      }
      else if (event.isShiftDown())
      {
         modifier = 10;
      }

      SelectionManager mgr = SelectionManager.get();
      Iterator iter = mgr.iteratorOfSelectedComponents();
      while (iter.hasNext())
      {
         JComponent comp = (JComponent) iter.next();

         Point loc = comp.getLocation();
         switch (event.getKeyCode())
         {
            case KeyEvent.VK_UP:
               loc.translate (0, -modifier);
               arrowKey = true;
               break;
            case KeyEvent.VK_DOWN:
               loc.translate (0, modifier);
               arrowKey = true;
               break;
            case KeyEvent.VK_LEFT:
               loc.translate (-modifier, 0);
               arrowKey = true;
               break;
            case KeyEvent.VK_RIGHT:
               loc.translate (modifier, 0);
               arrowKey = true;
               break;
            /*
             *  replaced this hack by composite actions JN
             *  case KeyEvent.VK_DELETE:
             *  try
             *  {
             *  / @todo: This is a hack! Key events should be defined in the XML file
             *  FSAObject obj = FSAObject.getFSAObjectFromJComponent (comp);
             *  Object logic = obj.getFSAInterface().getLogic(); // get object to delete
             *  UserInterfaceManager uiManager = UserInterfaceManager.get();
             *  JPopupMenu menu = uiManager.getFromPopupMenus (logic.getClass().getName());
             *  MenuElement[] elements = menu.getSubElements();
             *  int count = elements.length;
             *  boolean found = false;
             *  for (int i = 0; i < count; i++)
             *  {
             *  JMenuItem elem = (JMenuItem) elements[i];
             *  if (!found && elem.getText().startsWith ("Delete"))
             *  {
             *  ActionListener listener = elem.getActionListeners()[0];
             *  listener.actionPerformed (null); // execute first command
             *  event.consume();
             *  found = true;
             *  }
             *  }
             *  }
             *  catch (Exception e)
             *  {
             *  log.error ("Error in ArrowMoveListener[]");
             *  }
             *  break;
             */
         }
         comp.setLocation (loc);
      }

      // if no items are selected we want the scrollbars to react
      if (arrowKey && mgr.sizeOfSelectedComponents() > 0)
      {
         event.consume();
      }
   }


   /**
    * Nothing will be done on this event.
    *
    * @param event  KeyEvent
    */
   public void keyReleased (KeyEvent event)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void selectionChanged (SelectionEvent event)
   {
      if (event.getSource() instanceof JComponent)
      {
          ((JComponent) event.getSource()).requestFocusInWindow();
      }
   }

}

/*
 * $Log: ArrowMoveListener.java,v $
 * Revision 1.16.2.1  2005/08/23 08:24:46  lowende
 * Removed compile warnings.
 *
 */
