/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.actions;

import java.awt.*;
import java.awt.event.ActionEvent;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.FSAGrab;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import de.upb.lib.userinterface.ElementInitializer;


/**
 * @author    $Author: fklar $
 * @version   $Revision: 1.10.2.1 $
 */
public class GrabAutoAlignAction extends AbstractAction implements ElementInitializer
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void actionPerformed (ActionEvent event)
   {
      JComponent comp = (JComponent) SelectionManager.get().getPopupSource();
      JGrab jGrab = findGrab (comp);

      if (jGrab != null)
      {
         boolean newTransientState = ! (jGrab.isAutoAlignment() || jGrab.isAutoOrientation());
         jGrab.setAutoAlignment (newTransientState);
         jGrab.setAutoOrientation (newTransientState);

         // save / release new state, so it will be persistent
         // even if graphical instance is destroyed, when diagram is closed
         FSAGrab grab = (FSAGrab) FSAObject.getFSAObjectFromJComponent (jGrab);
         if (grab != null)
         {
            grab.setTransientProperties (newTransientState);

            // just save, if new state is not transient,
            // to avoid unnecessary method-calls
            if (newTransientState == false)
            {
               grab.saveOrientation();
               grab.saveAlignment();
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param item    No description provided
    * @param source  No description provided
    */
   public void initialize (JComponent item, Object source)
   {
      if (source instanceof JComponent && item instanceof JCheckBoxMenuItem)
      {
         JCheckBoxMenuItem check = (JCheckBoxMenuItem) item;
         JGrab grab = findGrab ((JComponent) source);

         if (grab != null)
         {
            check.setEnabled (true);
            check.setSelected (! (grab.isAutoAlignment() && grab.isAutoOrientation()));
         }
         else
         {
            check.setSelected (false);
            check.setEnabled (false);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param comp  No description provided
    * @return      No description provided
    */
   private JGrab findGrab (JComponent comp)
   {
      Container cont = comp;

      while (cont != null)
      {
         if (cont instanceof JGrab)
         {
            return (JGrab) cont;
         }
         cont = cont.getParent();
      }
      return null;
   }
}

/*
 * $Log: GrabAutoAlignAction.java,v $
 * Revision 1.10.2.1  2005/05/25 12:48:44  fklar
 * saving of orientation and alignment in properties
 *
 */
