/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.swing.JUnderlinedPanel;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * UMLClass: 'FSAUnderlinedObject'
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.17 $
 */
public class FSAUnderlinedObject extends FSAPanel
{
   /**
    * Calls the constructor FSAPanel(incr, propName, parent) with propName = parent = null.
    *
    * @param incr  No description provided
    */
   public FSAUnderlinedObject (LogicUnparseInterface incr)
   {
      super (incr, null, null);
   }


   /**
    * Calls the constructor FSAPanel(incr, propName, parent) with propName = null.
    *
    * @param incr    No description provided
    * @param parent  No description provided
    */
   public FSAUnderlinedObject (LogicUnparseInterface incr, JComponent parent)
   {
      super (incr, null, parent);
   }


   /**
    * Inherited constructor from FSAPanel.
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSAUnderlinedObject (LogicUnparseInterface incr, String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * creates its inner component JUnderlinedPanel. UMLMethod: '+ createJComponent () : Void'
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JUnderlinedPanel panel = new JUnderlinedPanel();
      panel.setBackground (FSAObject.COLOR_BACKGROUND);
      panel.setForeground (FSAObject.COLOR_FOREGROUND);
      return  (panel);
   }


   /**
    * Delegates the method call to its inner component.
    *
    * @param newUnderlined  The new underlined value
    */
   public void setUnderlined (boolean newUnderlined)
   {
      super.setUnderlined (newUnderlined);
       ((JUnderlinedPanel) getJComponent()).setUnderlined (newUnderlined);
   }


   /**
    * Delegates the method call to its inner component.
    *
    * @param insets  The new lineInsets value
    */
   public void setLineInsets (Insets insets)
   {
       ((JUnderlinedPanel) getJComponent()).setLineInsets (insets);
   }

}

/*
 * $Log: FSAUnderlinedObject.java,v $
 * Revision 1.17  2004/11/03 10:17:52  lowende
 * Javadoc warnings removed.
 *
 */
