/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import java.util.Iterator;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.fsa.unparse.UnparseManager;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;


/**
 * @author    joerg
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 * @version   $Revision: 1.1.2.1 $ $Date: 2005/07/04 15:16:33 $
 */
public class FSAToolBox
{
   /**
    * Get the item's main FSAContainer. The container is identified by the propertyName defined
    * int the UnparseModule (default: entry).
    *
    * @param item  This UMLDiagramItem's main FSAContainer is returned.
    * @return      The item's main FSAContainer.
    * @see         UMLDiagramItem
    * @see         FSAContainer
    * @see         FSAObject#getPropertyName
    */
   public static FSAContainer getMainFSAContainer (ASGElement item)
   {
      return (FSAContainer) getFSAObject (item, UnparseManager.get().getUnparseModule (item).getMainFsaName());
   }


   /**
    * Get item's FSAObject with given propertyName.
    *
    * @param item          The UMLDiagramItem's FSAObjects are searched.
    * @param propertyName  identifies item's FSAObject.
    * @return              The item's FSAObject with given propertyName.
    * @see                 UMLDiagramItem
    * @see                 FSAObject
    * @see                 FSAObject#getPropertyName
    */
   public static FSAObject getFSAObject (ASGElement item,
                                         String propertyName)
   {
      // Walk through all FSAObjects and return the first one with a
      // propertyName == "propertyName"
      FSAObject object = null;
      Iterator iter = item.iteratorOfFsaObjects();
      while (iter.hasNext() && object == null)
      {
         FSAObject i = (FSAObject) iter.next();
         if (i.getPropertyName().equals (propertyName))
         {
            object = i;
         }
      }
      return object;
   }

}

/*
 * $Log: FSAToolBox.java,v $
 * Revision 1.1.2.1  2005/07/04 15:16:33  joerg
 * Moved usecase package to plugin module.
 *
 */
