/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * UMLClass: 'FSALayeredPane'
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.20 $
 */
public class FSALayeredPane extends FSAContainer
{
   /**
    * Constructor for class FSALayeredPane
    *
    * @param incr  No description provided
    */
   public FSALayeredPane (LogicUnparseInterface incr)
   {
      this (incr, null);
   }


   /**
    * Constructor for class FSALayeredPane
    *
    * @param incr    No description provided
    * @param parent  No description provided
    */
   public FSALayeredPane (LogicUnparseInterface incr, JComponent parent)
   {
      super (incr, null, parent);
   }


   /**
    * Constructor for class FSALayeredPane
    *
    * @param incr       No description provided
    * @param parent     No description provided
    * @param component  No description provided
    */
   public FSALayeredPane (LogicUnparseInterface incr, JComponent parent, JComponent component)
   {
      super (incr, null, parent, component);
   }


   /**
    * Constructor for class FSALayeredPane
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSALayeredPane (LogicUnparseInterface incr, String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * Constructor for class FSALayeredPane
    *
    * @param incr       No description provided
    * @param propName   No description provided
    * @param parent     No description provided
    * @param component  No description provided
    */
   public FSALayeredPane (LogicUnparseInterface incr, String propName, JComponent parent, JComponent component)
   {
      super (incr, propName, parent, component);
   }


   /**
    * creates a standard JLayeredPane with frame for this FSAFrame UMLMethod: '+ createJComponent
    * () : Void'
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JLayeredPane pane = new JLayeredPane();
      pane.setBackground (FSAObject.COLOR_BACKGROUND);
      pane.setForeground (FSAObject.COLOR_FOREGROUND);
      pane.setOpaque (true);
      pane.setDoubleBuffered (true);
      return  (pane);
   }


   /**
    * Sets the specified LayoutManager for the associated JLayeredPane.
    *
    * @param layout  The new layout value
    */
   public void setLayout (LayoutManager layout)
   {
      getJComponent().setLayout (layout);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param object  No description provided
    */
   public void removeFromChildren (FSAObject object)
   {
      super.removeFromChildren (object);
      JComponent myComp = getJComponent();
      if (myComp != null && object != null && object.getJComponent() != null)
      {
         myComp.repaint();
      }
   }


   /**
    * update the jComponent to reflect this value UMLMethod: '+ setJComponentValue (value :
    * Object) : Void'
    *
    * @param value  The new jComponentValue value
    */
   public void setJComponentValue (Object value) { }


   /**
    * get the value that is currently visualised by the jComponent UMLMethod: '+ getJComponentValue
    * () : Object'
    *
    * @return   The jComponentValue value
    */
   public Object getJComponentValue()
   { // FSAObject

      return null;
   }


   /**
    * Sets the selected attribute of the FSALayeredPane object
    *
    * @param selected  The new selected value
    */
   public void setSelected (boolean selected) { }


   /**
    * Get the selected attribute of the FSALayeredPane object
    *
    * @return   The selected value
    */
   public boolean isSelected()
   {
      return false;
   }


   /**
    * Sets the focused attribute of the FSALayeredPane object
    *
    * @param focused  The new focused value
    */
   public void setFocused (boolean focused) { }
}

/*
 * $Log: FSALayeredPane.java,v $
 * Revision 1.20  2004/11/03 10:17:52  lowende
 * Javadoc warnings removed.
 *
 */
